@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointId The identifier of the firewall endpoint that AWS Network Firewall has instantiated in the subnet. You use this to identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through the endpoint.
 * @property status
 * @property subnetId The unique identifier for the subnet.
 */
public data class GetFirewallFirewallStatusSyncStateAttachment(
    public val endpointId: String,
    public val status: String,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallFirewallStatusSyncStateAttachment): GetFirewallFirewallStatusSyncStateAttachment = GetFirewallFirewallStatusSyncStateAttachment(
            endpointId = javaType.endpointId(),
            status = javaType.status(),
            subnetId = javaType.subnetId(),
        )
    }
}
