@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getFirewallPolicy.
 * @property arn
 * @property description Description of the firewall policy.
 * @property firewallPolicies The [policy][2] for the specified firewall policy.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property tags Key-value tags for the firewall policy.
 * @property updateToken Token used for optimistic locking.
 */
public data class GetFirewallPolicyResult(
    public val arn: String? = null,
    public val description: String,
    public val firewallPolicies: List<GetFirewallPolicyFirewallPolicy>,
    public val id: String,
    public val name: String? = null,
    public val tags: Map<String, String>,
    public val updateToken: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallPolicyResult): GetFirewallPolicyResult = GetFirewallPolicyResult(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            description = javaType.description(),
            firewallPolicies = javaType.firewallPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyFirewallPolicy.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updateToken = javaType.updateToken(),
        )
    }
}
