@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getFirewall.
 * @property arn ARN of the firewall.
 * @property deleteProtection A flag indicating whether the firewall is protected against deletion.
 * @property description Description of the firewall.
 * @property encryptionConfigurations AWS Key Management Service (AWS KMS) encryption settings for the firewall.
 * @property firewallPolicyArn ARN of the VPC Firewall policy.
 * @property firewallPolicyChangeProtection A flag indicating whether the firewall is protected against a change to the firewall policy association.
 * @property firewallStatuses Nested list of information about the current status of the firewall.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Descriptive name of the firewall.
 * @property subnetChangeProtection A flag indicating whether the firewall is protected against changes to the subnet associations.
 * @property subnetMappings Set of configuration blocks describing the public subnets. Each subnet must belong to a different Availability Zone in the VPC. AWS Network Firewall creates a firewall endpoint in each subnet.
 * @property tags Map of resource tags to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property updateToken String token used when updating a firewall.
 * @property vpcId Unique identifier of the VPC where AWS Network Firewall should create the firewall.
 */
public data class GetFirewallResult(
    public val arn: String,
    public val deleteProtection: Boolean,
    public val description: String,
    public val encryptionConfigurations: List<GetFirewallEncryptionConfiguration>,
    public val firewallPolicyArn: String,
    public val firewallPolicyChangeProtection: Boolean,
    public val firewallStatuses: List<GetFirewallFirewallStatus>,
    public val id: String,
    public val name: String,
    public val subnetChangeProtection: Boolean,
    public val subnetMappings: List<GetFirewallSubnetMapping>,
    public val tags: Map<String, String>,
    public val updateToken: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallResult): GetFirewallResult = GetFirewallResult(
            arn = javaType.arn(),
            deleteProtection = javaType.deleteProtection(),
            description = javaType.description(),
            encryptionConfigurations = javaType.encryptionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallEncryptionConfiguration.Companion.toKotlin(args0)
                })
            }),
            firewallPolicyArn = javaType.firewallPolicyArn(),
            firewallPolicyChangeProtection = javaType.firewallPolicyChangeProtection(),
            firewallStatuses = javaType.firewallStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallFirewallStatus.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            subnetChangeProtection = javaType.subnetChangeProtection(),
            subnetMappings = javaType.subnetMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallSubnetMapping.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            updateToken = javaType.updateToken(),
            vpcId = javaType.vpcId(),
        )
    }
}
