@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ipSets Set of configuration blocks that define IP address information. See IP Sets below for details.
 * @property portSets Set of configuration blocks that define port range information. See Port Sets below for details.
 */
public data class RuleGroupRuleGroupRuleVariables(
    public val ipSets: List<RuleGroupRuleGroupRuleVariablesIpSet>? = null,
    public val portSets: List<RuleGroupRuleGroupRuleVariablesPortSet>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRuleVariables): RuleGroupRuleGroupRuleVariables = RuleGroupRuleGroupRuleVariables(
            ipSets = javaType.ipSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRuleVariablesIpSet.Companion.toKotlin(args0)
                })
            }),
            portSets = javaType.portSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRuleVariablesPortSet.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
