@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action Action to take with packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, AWS Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow. Valid values: `ALERT`, `DROP`, `PASS`, or `REJECT`.
 * @property header A configuration block containing the stateful 5-tuple inspection criteria for the rule, used to inspect traffic flows. See Header below for details.
 * @property ruleOptions Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
 */
public data class RuleGroupRuleGroupRulesSourceStatefulRule(
    public val action: String,
    public val `header`: RuleGroupRuleGroupRulesSourceStatefulRuleHeader,
    public val ruleOptions: List<RuleGroupRuleGroupRulesSourceStatefulRuleRuleOption>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSourceStatefulRule): RuleGroupRuleGroupRulesSourceStatefulRule = RuleGroupRuleGroupRulesSourceStatefulRule(
            action = javaType.action(),
            `header` = javaType.`header`().let({ args0 ->
                com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatefulRuleHeader.Companion.toKotlin(args0)
            }),
            ruleOptions = javaType.ruleOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatefulRuleRuleOption.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
