@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destination The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
 * @property destinationPort The destination port to inspect for. To match with any address, specify `ANY`.
 * @property direction The direction of traffic flow to inspect. Valid values: `ANY` or `FORWARD`.
 * @property protocol The protocol to inspect. Valid values: `IP`, `TCP`, `UDP`, `ICMP`, `HTTP`, `FTP`, `TLS`, `SMB`, `DNS`, `DCERPC`, `SSH`, `SMTP`, `IMAP`, `MSN`, `KRB5`, `IKEV2`, `TFTP`, `NTP`, `DHCP`.
 * @property source The source IP address or address range for, in CIDR notation. To match with any address, specify `ANY`.
 * @property sourcePort The source port to inspect for. To match with any address, specify `ANY`.
 */
public data class RuleGroupRuleGroupRulesSourceStatefulRuleHeader(
    public val destination: String,
    public val destinationPort: String,
    public val direction: String,
    public val protocol: String,
    public val source: String,
    public val sourcePort: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSourceStatefulRuleHeader): RuleGroupRuleGroupRulesSourceStatefulRuleHeader =
            RuleGroupRuleGroupRulesSourceStatefulRuleHeader(
                destination = javaType.destination(),
                destinationPort = javaType.destinationPort(),
                direction = javaType.direction(),
                protocol = javaType.protocol(),
                source = javaType.source(),
                sourcePort = javaType.sourcePort(),
            )
    }
}
