@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customActions Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
 * @property statelessRules Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
 */
public data class RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActions(
    public val customActions: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomAction>? = null,
    public val statelessRules: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActions): RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActions =
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActions(
                customActions = javaType.customActions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomAction.Companion.toKotlin(args0)
                    })
                }),
                statelessRules = javaType.statelessRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRule.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
