@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property destinationPorts Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Port below for details.
 * @property destinations Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
 * @property protocols Set of protocols to inspect for, specified using the protocol's assigned internet protocol number (IANA). If not specified, this matches with any protocol.
 * @property sourcePorts Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Port below for details.
 * @property sources Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
 * @property tcpFlags Set of configuration blocks containing the TCP flags and masks to inspect for. If not specified, this matches with any settings.
 */
public data class
RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributes(
    public val destinationPorts: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesDestinationPort>? =
        null,
    public val destinations: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesDestination>? =
        null,
    public val protocols: List<Int>? = null,
    public val sourcePorts: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesSourcePort>? =
        null,
    public val sources: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesSource>? =
        null,
    public val tcpFlags: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlag>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributes): RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributes =
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributes(
                destinationPorts = javaType.destinationPorts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesDestinationPort.Companion.toKotlin(args0)
                    })
                }),
                destinations = javaType.destinations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesDestination.Companion.toKotlin(args0)
                    })
                }),
                protocols = javaType.protocols().map({ args0 -> args0 }),
                sourcePorts = javaType.sourcePorts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesSourcePort.Companion.toKotlin(args0)
                    })
                }),
                sources = javaType.sources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesSource.Companion.toKotlin(args0)
                    })
                }),
                tcpFlags = javaType.tcpFlags().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinitionMatchAttributesTcpFlag.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
