@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificateArn ARN of the certificate.
 * @property certificateSerial Serial number of the certificate.
 * @property status Status of the certificate.
 * @property statusMessage Details about the certificate status, including information about certificate errors.
 */
public data class TlsInspectionConfigurationCertificate(
    public val certificateArn: String,
    public val certificateSerial: String,
    public val status: String,
    public val statusMessage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.TlsInspectionConfigurationCertificate): TlsInspectionConfigurationCertificate = TlsInspectionConfigurationCertificate(
            certificateArn = javaType.certificateArn(),
            certificateSerial = javaType.certificateSerial(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
        )
    }
}
