@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyId ARN of the Amazon Web Services Key Management Service (KMS) customer managed key.
 * @property type Type of KMS key to use for encryption of your Network Firewall resources. Valid values: `AWS_OWNED_KMS_KEY`, `CUSTOMER_KMS`.
 */
public data class TlsInspectionConfigurationEncryptionConfiguration(
    public val keyId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.TlsInspectionConfigurationEncryptionConfiguration): TlsInspectionConfigurationEncryptionConfiguration =
            TlsInspectionConfigurationEncryptionConfiguration(
                keyId = javaType.keyId(),
                type = javaType.type(),
            )
    }
}
