@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certificateAuthorityArn ARN of the imported certificate authority (CA) certificate within Certificate Manager (ACM) to use for outbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) for limitations on CA certificates.
 * @property checkCertificateRevocationStatus Check Certificate Revocation Status block. Detailed below.
 * @property scopes Scope block. Detailed below.
 * @property serverCertificates Server certificates to use for inbound SSL/TLS inspection. See [Using SSL/TLS certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html).
 */
public data class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfiguration(
    public val certificateAuthorityArn: String? = null,
    public val checkCertificateRevocationStatus: TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatus? =
        null,
    public val scopes: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScope>? =
        null,
    public val serverCertificates: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificate>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfiguration): TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfiguration =
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfiguration(
                certificateAuthorityArn = javaType.certificateAuthorityArn().map({ args0 -> args0 }).orElse(null),
                checkCertificateRevocationStatus = javaType.checkCertificateRevocationStatus().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationCheckCertificateRevocationStatus.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                scopes = javaType.scopes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScope.Companion.toKotlin(args0)
                    })
                }),
                serverCertificates = javaType.serverCertificates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationServerCertificate.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
