@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property destinationPorts Set of configuration blocks describing the destination ports to inspect for. If not specified, this matches with any destination port. See Destination Ports below for details.
 * @property destinations Set of configuration blocks describing the destination IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any destination address. See Destination below for details.
 * @property protocols Set of protocols to inspect for, specified using the protocol's assigned internet protocol number (IANA). Network Firewall currently supports TCP only. Valid values: `6`
 * @property sourcePorts Set of configuration blocks describing the source ports to inspect for. If not specified, this matches with any source port. See Source Ports below for details.
 * @property sources Set of configuration blocks describing the source IP address and address ranges to inspect for, in CIDR notation. If not specified, this matches with any source address. See Source below for details.
 */
public data class
TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScope(
    public val destinationPorts: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPort>? =
        null,
    public val destinations: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestination>? =
        null,
    public val protocols: List<Int>,
    public val sourcePorts: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePort>? =
        null,
    public val sources: List<TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSource>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScope): TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScope =
            TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScope(
                destinationPorts = javaType.destinationPorts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestinationPort.Companion.toKotlin(args0)
                    })
                }),
                destinations = javaType.destinations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeDestination.Companion.toKotlin(args0)
                    })
                }),
                protocols = javaType.protocols().map({ args0 -> args0 }),
                sourcePorts = javaType.sourcePorts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSourcePort.Companion.toKotlin(args0)
                    })
                }),
                sources = javaType.sources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.TlsInspectionConfigurationTlsInspectionConfigurationServerCertificateConfigurationScopeSource.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
