@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.AttachmentAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager Attachment Accepter.
 * ## Example Usage
 * ### Example with VPC attachment
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.networkmanager.AttachmentAccepter("test", {
 *     attachmentId: vpc.id,
 *     attachmentType: vpc.attachmentType,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.networkmanager.AttachmentAccepter("test",
 *     attachment_id=vpc["id"],
 *     attachment_type=vpc["attachmentType"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.NetworkManager.AttachmentAccepter("test", new()
 *     {
 *         AttachmentId = vpc.Id,
 *         AttachmentType = vpc.AttachmentType,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewAttachmentAccepter(ctx, "test", &networkmanager.AttachmentAccepterArgs{
 * 			AttachmentId:   pulumi.Any(vpc.Id),
 * 			AttachmentType: pulumi.Any(vpc.AttachmentType),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter("test", AttachmentAccepterArgs.builder()
 *             .attachmentId(vpc.id())
 *             .attachmentType(vpc.attachmentType())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:networkmanager:AttachmentAccepter
 *     properties:
 *       attachmentId: ${vpc.id}
 *       attachmentType: ${vpc.attachmentType}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example with site-to-site VPN attachment
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.networkmanager.AttachmentAccepter("test", {
 *     attachmentId: vpn.id,
 *     attachmentType: vpn.attachmentType,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.networkmanager.AttachmentAccepter("test",
 *     attachment_id=vpn["id"],
 *     attachment_type=vpn["attachmentType"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.NetworkManager.AttachmentAccepter("test", new()
 *     {
 *         AttachmentId = vpn.Id,
 *         AttachmentType = vpn.AttachmentType,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewAttachmentAccepter(ctx, "test", &networkmanager.AttachmentAccepterArgs{
 * 			AttachmentId:   pulumi.Any(vpn.Id),
 * 			AttachmentType: pulumi.Any(vpn.AttachmentType),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter("test", AttachmentAccepterArgs.builder()
 *             .attachmentId(vpn.id())
 *             .attachmentType(vpn.attachmentType())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:networkmanager:AttachmentAccepter
 *     properties:
 *       attachmentId: ${vpn.id}
 *       attachmentType: ${vpn.attachmentType}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property attachmentId The ID of the attachment.
 * @property attachmentType The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
 */
public data class AttachmentAccepterArgs(
    public val attachmentId: Output<String>? = null,
    public val attachmentType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.AttachmentAccepterArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.AttachmentAccepterArgs =
        com.pulumi.aws.networkmanager.AttachmentAccepterArgs.builder()
            .attachmentId(attachmentId?.applyValue({ args0 -> args0 }))
            .attachmentType(attachmentType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachmentAccepterArgs].
 */
@PulumiTagMarker
public class AttachmentAccepterArgsBuilder internal constructor() {
    private var attachmentId: Output<String>? = null

    private var attachmentType: Output<String>? = null

    /**
     * @param value The ID of the attachment.
     */
    @JvmName("erbhseqjychigmpk")
    public suspend fun attachmentId(`value`: Output<String>) {
        this.attachmentId = value
    }

    /**
     * @param value The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
     */
    @JvmName("mijxlplpuefeijsx")
    public suspend fun attachmentType(`value`: Output<String>) {
        this.attachmentType = value
    }

    /**
     * @param value The ID of the attachment.
     */
    @JvmName("ofecwnuweqbfiadt")
    public suspend fun attachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentId = mapped
    }

    /**
     * @param value The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
     */
    @JvmName("ollpcppskdcccoyq")
    public suspend fun attachmentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentType = mapped
    }

    internal fun build(): AttachmentAccepterArgs = AttachmentAccepterArgs(
        attachmentId = attachmentId,
        attachmentType = attachmentType,
    )
}
