@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectAttachmentOptions
import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectAttachmentOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ConnectAttachment].
 */
@PulumiTagMarker
public class ConnectAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectAttachmentArgs = ConnectAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectAttachmentArgsBuilder.() -> Unit) {
        val builder = ConnectAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectAttachment {
        val builtJavaResource = com.pulumi.aws.networkmanager.ConnectAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectAttachment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Manager ConnectAttachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with attachment accepter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleAttachmentAccepter = new aws.networkmanager.AttachmentAccepter("example", {
 *     attachmentId: example.id,
 *     attachmentType: example.attachmentType,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * }, {
 *     dependsOn: [test],
 * });
 * const example2 = new aws.networkmanager.AttachmentAccepter("example2", {
 *     attachmentId: exampleConnectAttachment.id,
 *     attachmentType: exampleConnectAttachment.attachmentType,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_attachment_accepter = aws.networkmanager.AttachmentAccepter("example",
 *     attachment_id=example.id,
 *     attachment_type=example.attachment_type)
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * example2 = aws.networkmanager.AttachmentAccepter("example2",
 *     attachment_id=example_connect_attachment.id,
 *     attachment_type=example_connect_attachment.attachment_type)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleAttachmentAccepter = new Aws.NetworkManager.AttachmentAccepter("example", new()
 *     {
 *         AttachmentId = example.Id,
 *         AttachmentType = example.AttachmentType,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 *     var example2 = new Aws.NetworkManager.AttachmentAccepter("example2", new()
 *     {
 *         AttachmentId = exampleConnectAttachment.Id,
 *         AttachmentType = exampleConnectAttachment.AttachmentType,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewAttachmentAccepter(ctx, "example", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: example.ID(),
 * AttachmentType: example.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * }, pulumi.DependsOn([]pulumi.Resource{
 * test,
 * }))
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewAttachmentAccepter(ctx, "example2", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: exampleConnectAttachment.ID(),
 * AttachmentType: exampleConnectAttachment.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleAttachmentAccepter = new AttachmentAccepter("exampleAttachmentAccepter", AttachmentAccepterArgs.builder()
 *             .attachmentId(example.id())
 *             .attachmentType(example.attachmentType())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *         var example2 = new AttachmentAccepter("example2", AttachmentAccepterArgs.builder()
 *             .attachmentId(exampleConnectAttachment.id())
 *             .attachmentType(exampleConnectAttachment.attachmentType())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connect_attachment` using the attachment ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/connectAttachment:ConnectAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 */
public class ConnectAttachment internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.ConnectAttachment,
) : KotlinCustomResource(javaResource, ConnectAttachmentMapper) {
    /**
     * The ARN of the attachment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val attachmentId: Output<String>
        get() = javaResource.attachmentId().applyValue({ args0 -> args0 })

    /**
     * The policy rule number associated with the attachment.
     */
    public val attachmentPolicyRuleNumber: Output<Int>
        get() = javaResource.attachmentPolicyRuleNumber().applyValue({ args0 -> args0 })

    /**
     * The type of attachment.
     */
    public val attachmentType: Output<String>
        get() = javaResource.attachmentType().applyValue({ args0 -> args0 })

    /**
     * The ARN of a core network.
     */
    public val coreNetworkArn: Output<String>
        get() = javaResource.coreNetworkArn().applyValue({ args0 -> args0 })

    /**
     * The ID of a core network where you want to create the attachment.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    /**
     * The Region where the edge is located.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * Options block. See options for more information.
     * The following arguments are optional:
     */
    public val options: Output<ConnectAttachmentOptions>
        get() = javaResource.options().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The ID of the attachment account owner.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The attachment resource ARN.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The name of the segment attachment.
     */
    public val segmentName: Output<String>
        get() = javaResource.segmentName().applyValue({ args0 -> args0 })

    /**
     * The state of the attachment.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the attachment between the two connections.
     */
    public val transportAttachmentId: Output<String>
        get() = javaResource.transportAttachmentId().applyValue({ args0 -> args0 })
}

public object ConnectAttachmentMapper : ResourceMapper<ConnectAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.ConnectAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ConnectAttachment = ConnectAttachment(
        javaResource as
            com.pulumi.aws.networkmanager.ConnectAttachment,
    )
}

/**
 * @see [ConnectAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectAttachment].
 */
public suspend fun connectAttachment(
    name: String,
    block: suspend ConnectAttachmentResourceBuilder.() -> Unit,
): ConnectAttachment {
    val builder = ConnectAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectAttachment(name: String): ConnectAttachment {
    val builder = ConnectAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
