@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.ConnectAttachmentArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectAttachmentOptionsArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectAttachmentOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager ConnectAttachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with attachment accepter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleAttachmentAccepter = new aws.networkmanager.AttachmentAccepter("example", {
 *     attachmentId: example.id,
 *     attachmentType: example.attachmentType,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * }, {
 *     dependsOn: [test],
 * });
 * const example2 = new aws.networkmanager.AttachmentAccepter("example2", {
 *     attachmentId: exampleConnectAttachment.id,
 *     attachmentType: exampleConnectAttachment.attachmentType,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_attachment_accepter = aws.networkmanager.AttachmentAccepter("example",
 *     attachment_id=example.id,
 *     attachment_type=example.attachment_type)
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * example2 = aws.networkmanager.AttachmentAccepter("example2",
 *     attachment_id=example_connect_attachment.id,
 *     attachment_type=example_connect_attachment.attachment_type)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleAttachmentAccepter = new Aws.NetworkManager.AttachmentAccepter("example", new()
 *     {
 *         AttachmentId = example.Id,
 *         AttachmentType = example.AttachmentType,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 *     var example2 = new Aws.NetworkManager.AttachmentAccepter("example2", new()
 *     {
 *         AttachmentId = exampleConnectAttachment.Id,
 *         AttachmentType = exampleConnectAttachment.AttachmentType,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewAttachmentAccepter(ctx, "example", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: example.ID(),
 * AttachmentType: example.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * }, pulumi.DependsOn([]pulumi.Resource{
 * test,
 * }))
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewAttachmentAccepter(ctx, "example2", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: exampleConnectAttachment.ID(),
 * AttachmentType: exampleConnectAttachment.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleAttachmentAccepter = new AttachmentAccepter("exampleAttachmentAccepter", AttachmentAccepterArgs.builder()
 *             .attachmentId(example.id())
 *             .attachmentType(example.attachmentType())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *         var example2 = new AttachmentAccepter("example2", AttachmentAccepterArgs.builder()
 *             .attachmentId(exampleConnectAttachment.id())
 *             .attachmentType(exampleConnectAttachment.attachmentType())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connect_attachment` using the attachment ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/connectAttachment:ConnectAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property coreNetworkId The ID of a core network where you want to create the attachment.
 * @property edgeLocation The Region where the edge is located.
 * @property options Options block. See options for more information.
 * The following arguments are optional:
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transportAttachmentId The ID of the attachment between the two connections.
 */
public data class ConnectAttachmentArgs(
    public val coreNetworkId: Output<String>? = null,
    public val edgeLocation: Output<String>? = null,
    public val options: Output<ConnectAttachmentOptionsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transportAttachmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.ConnectAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.ConnectAttachmentArgs =
        com.pulumi.aws.networkmanager.ConnectAttachmentArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .edgeLocation(edgeLocation?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transportAttachmentId(transportAttachmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectAttachmentArgs].
 */
@PulumiTagMarker
public class ConnectAttachmentArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var edgeLocation: Output<String>? = null

    private var options: Output<ConnectAttachmentOptionsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transportAttachmentId: Output<String>? = null

    /**
     * @param value The ID of a core network where you want to create the attachment.
     */
    @JvmName("moccemowahmpdwss")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value The Region where the edge is located.
     */
    @JvmName("foqeyqmphwmmrjpy")
    public suspend fun edgeLocation(`value`: Output<String>) {
        this.edgeLocation = value
    }

    /**
     * @param value Options block. See options for more information.
     * The following arguments are optional:
     */
    @JvmName("nkrurstmfoxrbkrb")
    public suspend fun options(`value`: Output<ConnectAttachmentOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kiaovsfwqmjsptgr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the attachment between the two connections.
     */
    @JvmName("bxlqnknohrjuoeym")
    public suspend fun transportAttachmentId(`value`: Output<String>) {
        this.transportAttachmentId = value
    }

    /**
     * @param value The ID of a core network where you want to create the attachment.
     */
    @JvmName("gmkymrvkexbnknqk")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value The Region where the edge is located.
     */
    @JvmName("xudhcshauqvonsfi")
    public suspend fun edgeLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edgeLocation = mapped
    }

    /**
     * @param value Options block. See options for more information.
     * The following arguments are optional:
     */
    @JvmName("xmxtqgxanmjjaqcy")
    public suspend fun options(`value`: ConnectAttachmentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument Options block. See options for more information.
     * The following arguments are optional:
     */
    @JvmName("emkefwhbpsrdckaj")
    public suspend fun options(argument: suspend ConnectAttachmentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectAttachmentOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hcdqviofprgxmyja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cbsnpcpxiidtgwhi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the attachment between the two connections.
     */
    @JvmName("koipirkvqeprajgp")
    public suspend fun transportAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportAttachmentId = mapped
    }

    internal fun build(): ConnectAttachmentArgs = ConnectAttachmentArgs(
        coreNetworkId = coreNetworkId,
        edgeLocation = edgeLocation,
        options = options,
        tags = tags,
        transportAttachmentId = transportAttachmentId,
    )
}
