@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerBgpOptions
import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerBgpOptions.Companion.toKotlin as connectPeerBgpOptionsToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerConfiguration.Companion.toKotlin as connectPeerConfigurationToKotlin

/**
 * Builder for [ConnectPeer].
 */
@PulumiTagMarker
public class ConnectPeerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectPeerArgs = ConnectPeerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectPeerArgsBuilder.() -> Unit) {
        val builder = ConnectPeerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectPeer {
        val builtJavaResource = com.pulumi.aws.networkmanager.ConnectPeer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectPeer(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Manager Connect Peer.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * });
 * const exampleConnectPeer = new aws.networkmanager.ConnectPeer("example", {
 *     connectAttachmentId: exampleConnectAttachment.id,
 *     peerAddress: "127.0.0.1",
 *     bgpOptions: {
 *         peerAsn: 65000,
 *     },
 *     insideCidrBlocks: ["172&#46;16&#46;0&#46;0/16"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     })
 * example_connect_peer = aws.networkmanager.ConnectPeer("example",
 *     connect_attachment_id=example_connect_attachment.id,
 *     peer_address="127.0.0.1",
 *     bgp_options={
 *         "peer_asn": 65000,
 *     },
 *     inside_cidr_blocks=["172&#46;16&#46;0&#46;0/16"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     });
 *     var exampleConnectPeer = new Aws.NetworkManager.ConnectPeer("example", new()
 *     {
 *         ConnectAttachmentId = exampleConnectAttachment.Id,
 *         PeerAddress = "127.0.0.1",
 *         BgpOptions = new Aws.NetworkManager.Inputs.ConnectPeerBgpOptionsArgs
 *         {
 *             PeerAsn = 65000,
 *         },
 *         InsideCidrBlocks = new[]
 *         {
 *             "172.16.0.0/16",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectPeer(ctx, "example", &networkmanager.ConnectPeerArgs{
 * ConnectAttachmentId: exampleConnectAttachment.ID(),
 * PeerAddress: pulumi.String("127.0.0.1"),
 * BgpOptions: &networkmanager.ConnectPeerBgpOptionsArgs{
 * PeerAsn: pulumi.Int(65000),
 * },
 * InsideCidrBlocks: pulumi.StringArray{
 * pulumi.String("172.16.0.0/16"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.aws.networkmanager.ConnectPeer;
 * import com.pulumi.aws.networkmanager.ConnectPeerArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .connectAttachmentId(exampleConnectAttachment.id())
 *             .peerAddress("127.0.0.1")
 *             .bgpOptions(ConnectPeerBgpOptionsArgs.builder()
 *                 .peerAsn(65000)
 *                 .build())
 *             .insideCidrBlocks("172.16.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with attachment accepter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleAttachmentAccepter = new aws.networkmanager.AttachmentAccepter("example", {
 *     attachmentId: example.id,
 *     attachmentType: example.attachmentType,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * }, {
 *     dependsOn: [test],
 * });
 * const example2 = new aws.networkmanager.AttachmentAccepter("example2", {
 *     attachmentId: exampleConnectAttachment.id,
 *     attachmentType: exampleConnectAttachment.attachmentType,
 * });
 * const exampleConnectPeer = new aws.networkmanager.ConnectPeer("example", {
 *     connectAttachmentId: exampleConnectAttachment.id,
 *     peerAddress: "127.0.0.1",
 *     bgpOptions: {
 *         peerAsn: 65500,
 *     },
 *     insideCidrBlocks: ["172&#46;16&#46;0&#46;0/16"],
 * }, {
 *     dependsOn: [example2],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_attachment_accepter = aws.networkmanager.AttachmentAccepter("example",
 *     attachment_id=example.id,
 *     attachment_type=example.attachment_type)
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * example2 = aws.networkmanager.AttachmentAccepter("example2",
 *     attachment_id=example_connect_attachment.id,
 *     attachment_type=example_connect_attachment.attachment_type)
 * example_connect_peer = aws.networkmanager.ConnectPeer("example",
 *     connect_attachment_id=example_connect_attachment.id,
 *     peer_address="127.0.0.1",
 *     bgp_options={
 *         "peer_asn": 65500,
 *     },
 *     inside_cidr_blocks=["172&#46;16&#46;0&#46;0/16"],
 *     opts = pulumi.ResourceOptions(depends_on=[example2]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleAttachmentAccepter = new Aws.NetworkManager.AttachmentAccepter("example", new()
 *     {
 *         AttachmentId = example.Id,
 *         AttachmentType = example.AttachmentType,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 *     var example2 = new Aws.NetworkManager.AttachmentAccepter("example2", new()
 *     {
 *         AttachmentId = exampleConnectAttachment.Id,
 *         AttachmentType = exampleConnectAttachment.AttachmentType,
 *     });
 *     var exampleConnectPeer = new Aws.NetworkManager.ConnectPeer("example", new()
 *     {
 *         ConnectAttachmentId = exampleConnectAttachment.Id,
 *         PeerAddress = "127.0.0.1",
 *         BgpOptions = new Aws.NetworkManager.Inputs.ConnectPeerBgpOptionsArgs
 *         {
 *             PeerAsn = 65500,
 *         },
 *         InsideCidrBlocks = new[]
 *         {
 *             "172.16.0.0/16",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewAttachmentAccepter(ctx, "example", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: example.ID(),
 * AttachmentType: example.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * }, pulumi.DependsOn([]pulumi.Resource{
 * test,
 * }))
 * if err != nil {
 * return err
 * }
 * example2, err := networkmanager.NewAttachmentAccepter(ctx, "example2", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: exampleConnectAttachment.ID(),
 * AttachmentType: exampleConnectAttachment.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectPeer(ctx, "example", &networkmanager.ConnectPeerArgs{
 * ConnectAttachmentId: exampleConnectAttachment.ID(),
 * PeerAddress: pulumi.String("127.0.0.1"),
 * BgpOptions: &networkmanager.ConnectPeerBgpOptionsArgs{
 * PeerAsn: pulumi.Int(65500),
 * },
 * InsideCidrBlocks: pulumi.StringArray{
 * pulumi.String("172.16.0.0/16"),
 * },
 * }, pulumi.DependsOn([]pulumi.Resource{
 * example2,
 * }))
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.aws.networkmanager.ConnectPeer;
 * import com.pulumi.aws.networkmanager.ConnectPeerArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleAttachmentAccepter = new AttachmentAccepter("exampleAttachmentAccepter", AttachmentAccepterArgs.builder()
 *             .attachmentId(example.id())
 *             .attachmentType(example.attachmentType())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *         var example2 = new AttachmentAccepter("example2", AttachmentAccepterArgs.builder()
 *             .attachmentId(exampleConnectAttachment.id())
 *             .attachmentType(exampleConnectAttachment.attachmentType())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .connectAttachmentId(exampleConnectAttachment.id())
 *             .peerAddress("127.0.0.1")
 *             .bgpOptions(ConnectPeerBgpOptionsArgs.builder()
 *                 .peerAsn(65500)
 *                 .build())
 *             .insideCidrBlocks("172.16.0.0/16")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example2)
 *                 .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with a Tunnel-less Connect attachment
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "NO_ENCAP",
 *     },
 * });
 * const exampleConnectPeer = new aws.networkmanager.ConnectPeer("example", {
 *     connectAttachmentId: exampleConnectAttachment.id,
 *     peerAddress: "127.0.0.1",
 *     bgpOptions: {
 *         peerAsn: 65000,
 *     },
 *     subnetArn: test2.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "NO_ENCAP",
 *     })
 * example_connect_peer = aws.networkmanager.ConnectPeer("example",
 *     connect_attachment_id=example_connect_attachment.id,
 *     peer_address="127.0.0.1",
 *     bgp_options={
 *         "peer_asn": 65000,
 *     },
 *     subnet_arn=test2["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "NO_ENCAP",
 *         },
 *     });
 *     var exampleConnectPeer = new Aws.NetworkManager.ConnectPeer("example", new()
 *     {
 *         ConnectAttachmentId = exampleConnectAttachment.Id,
 *         PeerAddress = "127.0.0.1",
 *         BgpOptions = new Aws.NetworkManager.Inputs.ConnectPeerBgpOptionsArgs
 *         {
 *             PeerAsn = 65000,
 *         },
 *         SubnetArn = test2.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("NO_ENCAP"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectPeer(ctx, "example", &networkmanager.ConnectPeerArgs{
 * ConnectAttachmentId: exampleConnectAttachment.ID(),
 * PeerAddress: pulumi.String("127.0.0.1"),
 * BgpOptions: &networkmanager.ConnectPeerBgpOptionsArgs{
 * PeerAsn: pulumi.Int(65000),
 * },
 * SubnetArn: pulumi.Any(test2.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.aws.networkmanager.ConnectPeer;
 * import com.pulumi.aws.networkmanager.ConnectPeerArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("NO_ENCAP")
 *                 .build())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .connectAttachmentId(exampleConnectAttachment.id())
 *             .peerAddress("127.0.0.1")
 *             .bgpOptions(ConnectPeerBgpOptionsArgs.builder()
 *                 .peerAsn(65000)
 *                 .build())
 *             .subnetArn(test2.arn())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connect_peer` using the connect peer ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/connectPeer:ConnectPeer example connect-peer-061f3e96275db1acc
 * ```
 */
public class ConnectPeer internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.ConnectPeer,
) : KotlinCustomResource(javaResource, ConnectPeerMapper) {
    /**
     * The ARN of the attachment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Connect peer BGP options.
     */
    public val bgpOptions: Output<ConnectPeerBgpOptions>?
        get() = javaResource.bgpOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectPeerBgpOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration of the Connect peer.
     */
    public val configurations: Output<List<ConnectPeerConfiguration>>
        get() = javaResource.configurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> connectPeerConfigurationToKotlin(args0) })
            })
        })

    /**
     * The ID of the connection attachment.
     */
    public val connectAttachmentId: Output<String>
        get() = javaResource.connectAttachmentId().applyValue({ args0 -> args0 })

    public val connectPeerId: Output<String>
        get() = javaResource.connectPeerId().applyValue({ args0 -> args0 })

    /**
     * A Connect peer core network address.
     */
    public val coreNetworkAddress: Output<String>?
        get() = javaResource.coreNetworkAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of a core network.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The Region where the peer is located.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    public val insideCidrBlocks: Output<List<String>>?
        get() = javaResource.insideCidrBlocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The Connect peer address.
     * The following arguments are optional:
     */
    public val peerAddress: Output<String>
        get() = javaResource.peerAddress().applyValue({ args0 -> args0 })

    /**
     * The state of the Connect peer.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    public val subnetArn: Output<String>?
        get() = javaResource.subnetArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ConnectPeerMapper : ResourceMapper<ConnectPeer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.ConnectPeer::class == javaResource::class

    override fun map(javaResource: Resource): ConnectPeer = ConnectPeer(
        javaResource as
            com.pulumi.aws.networkmanager.ConnectPeer,
    )
}

/**
 * @see [ConnectPeer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectPeer].
 */
public suspend fun connectPeer(name: String, block: suspend ConnectPeerResourceBuilder.() -> Unit): ConnectPeer {
    val builder = ConnectPeerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectPeer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectPeer(name: String): ConnectPeer {
    val builder = ConnectPeerResourceBuilder()
    builder.name(name)
    return builder.build()
}
