@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.ConnectPeerArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectPeerBgpOptionsArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectPeerBgpOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager Connect Peer.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * });
 * const exampleConnectPeer = new aws.networkmanager.ConnectPeer("example", {
 *     connectAttachmentId: exampleConnectAttachment.id,
 *     peerAddress: "127.0.0.1",
 *     bgpOptions: {
 *         peerAsn: 65000,
 *     },
 *     insideCidrBlocks: ["172&#46;16&#46;0&#46;0/16"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     })
 * example_connect_peer = aws.networkmanager.ConnectPeer("example",
 *     connect_attachment_id=example_connect_attachment.id,
 *     peer_address="127.0.0.1",
 *     bgp_options={
 *         "peer_asn": 65000,
 *     },
 *     inside_cidr_blocks=["172&#46;16&#46;0&#46;0/16"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     });
 *     var exampleConnectPeer = new Aws.NetworkManager.ConnectPeer("example", new()
 *     {
 *         ConnectAttachmentId = exampleConnectAttachment.Id,
 *         PeerAddress = "127.0.0.1",
 *         BgpOptions = new Aws.NetworkManager.Inputs.ConnectPeerBgpOptionsArgs
 *         {
 *             PeerAsn = 65000,
 *         },
 *         InsideCidrBlocks = new[]
 *         {
 *             "172.16.0.0/16",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectPeer(ctx, "example", &networkmanager.ConnectPeerArgs{
 * ConnectAttachmentId: exampleConnectAttachment.ID(),
 * PeerAddress: pulumi.String("127.0.0.1"),
 * BgpOptions: &networkmanager.ConnectPeerBgpOptionsArgs{
 * PeerAsn: pulumi.Int(65000),
 * },
 * InsideCidrBlocks: pulumi.StringArray{
 * pulumi.String("172.16.0.0/16"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.aws.networkmanager.ConnectPeer;
 * import com.pulumi.aws.networkmanager.ConnectPeerArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .connectAttachmentId(exampleConnectAttachment.id())
 *             .peerAddress("127.0.0.1")
 *             .bgpOptions(ConnectPeerBgpOptionsArgs.builder()
 *                 .peerAsn(65000)
 *                 .build())
 *             .insideCidrBlocks("172.16.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with attachment accepter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleAttachmentAccepter = new aws.networkmanager.AttachmentAccepter("example", {
 *     attachmentId: example.id,
 *     attachmentType: example.attachmentType,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "GRE",
 *     },
 * }, {
 *     dependsOn: [test],
 * });
 * const example2 = new aws.networkmanager.AttachmentAccepter("example2", {
 *     attachmentId: exampleConnectAttachment.id,
 *     attachmentType: exampleConnectAttachment.attachmentType,
 * });
 * const exampleConnectPeer = new aws.networkmanager.ConnectPeer("example", {
 *     connectAttachmentId: exampleConnectAttachment.id,
 *     peerAddress: "127.0.0.1",
 *     bgpOptions: {
 *         peerAsn: 65500,
 *     },
 *     insideCidrBlocks: ["172&#46;16&#46;0&#46;0/16"],
 * }, {
 *     dependsOn: [example2],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_attachment_accepter = aws.networkmanager.AttachmentAccepter("example",
 *     attachment_id=example.id,
 *     attachment_type=example.attachment_type)
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "GRE",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[test]))
 * example2 = aws.networkmanager.AttachmentAccepter("example2",
 *     attachment_id=example_connect_attachment.id,
 *     attachment_type=example_connect_attachment.attachment_type)
 * example_connect_peer = aws.networkmanager.ConnectPeer("example",
 *     connect_attachment_id=example_connect_attachment.id,
 *     peer_address="127.0.0.1",
 *     bgp_options={
 *         "peer_asn": 65500,
 *     },
 *     inside_cidr_blocks=["172&#46;16&#46;0&#46;0/16"],
 *     opts = pulumi.ResourceOptions(depends_on=[example2]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleAttachmentAccepter = new Aws.NetworkManager.AttachmentAccepter("example", new()
 *     {
 *         AttachmentId = example.Id,
 *         AttachmentType = example.AttachmentType,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "GRE",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             test,
 *         },
 *     });
 *     var example2 = new Aws.NetworkManager.AttachmentAccepter("example2", new()
 *     {
 *         AttachmentId = exampleConnectAttachment.Id,
 *         AttachmentType = exampleConnectAttachment.AttachmentType,
 *     });
 *     var exampleConnectPeer = new Aws.NetworkManager.ConnectPeer("example", new()
 *     {
 *         ConnectAttachmentId = exampleConnectAttachment.Id,
 *         PeerAddress = "127.0.0.1",
 *         BgpOptions = new Aws.NetworkManager.Inputs.ConnectPeerBgpOptionsArgs
 *         {
 *             PeerAsn = 65500,
 *         },
 *         InsideCidrBlocks = new[]
 *         {
 *             "172.16.0.0/16",
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewAttachmentAccepter(ctx, "example", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: example.ID(),
 * AttachmentType: example.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("GRE"),
 * },
 * }, pulumi.DependsOn([]pulumi.Resource{
 * test,
 * }))
 * if err != nil {
 * return err
 * }
 * example2, err := networkmanager.NewAttachmentAccepter(ctx, "example2", &networkmanager.AttachmentAccepterArgs{
 * AttachmentId: exampleConnectAttachment.ID(),
 * AttachmentType: exampleConnectAttachment.AttachmentType,
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectPeer(ctx, "example", &networkmanager.ConnectPeerArgs{
 * ConnectAttachmentId: exampleConnectAttachment.ID(),
 * PeerAddress: pulumi.String("127.0.0.1"),
 * BgpOptions: &networkmanager.ConnectPeerBgpOptionsArgs{
 * PeerAsn: pulumi.Int(65500),
 * },
 * InsideCidrBlocks: pulumi.StringArray{
 * pulumi.String("172.16.0.0/16"),
 * },
 * }, pulumi.DependsOn([]pulumi.Resource{
 * example2,
 * }))
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.aws.networkmanager.ConnectPeer;
 * import com.pulumi.aws.networkmanager.ConnectPeerArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleAttachmentAccepter = new AttachmentAccepter("exampleAttachmentAccepter", AttachmentAccepterArgs.builder()
 *             .attachmentId(example.id())
 *             .attachmentType(example.attachmentType())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("GRE")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(test)
 *                 .build());
 *         var example2 = new AttachmentAccepter("example2", AttachmentAccepterArgs.builder()
 *             .attachmentId(exampleConnectAttachment.id())
 *             .attachmentType(exampleConnectAttachment.attachmentType())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .connectAttachmentId(exampleConnectAttachment.id())
 *             .peerAddress("127.0.0.1")
 *             .bgpOptions(ConnectPeerBgpOptionsArgs.builder()
 *                 .peerAsn(65500)
 *                 .build())
 *             .insideCidrBlocks("172.16.0.0/16")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example2)
 *                 .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Usage with a Tunnel-less Connect attachment
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: exampleAwsSubnet.map(__item => __item.arn),
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * const exampleConnectAttachment = new aws.networkmanager.ConnectAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transportAttachmentId: example.id,
 *     edgeLocation: example.edgeLocation,
 *     options: {
 *         protocol: "NO_ENCAP",
 *     },
 * });
 * const exampleConnectPeer = new aws.networkmanager.ConnectPeer("example", {
 *     connectAttachmentId: exampleConnectAttachment.id,
 *     peerAddress: "127.0.0.1",
 *     bgpOptions: {
 *         peerAsn: 65000,
 *     },
 *     subnetArn: test2.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[__item["arn"] for __item in example_aws_subnet],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * example_connect_attachment = aws.networkmanager.ConnectAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transport_attachment_id=example.id,
 *     edge_location=example.edge_location,
 *     options={
 *         "protocol": "NO_ENCAP",
 *     })
 * example_connect_peer = aws.networkmanager.ConnectPeer("example",
 *     connect_attachment_id=example_connect_attachment.id,
 *     peer_address="127.0.0.1",
 *     bgp_options={
 *         "peer_asn": 65000,
 *     },
 *     subnet_arn=test2["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = exampleAwsSubnet.Select(__item => __item.Arn).ToList(),
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 *     var exampleConnectAttachment = new Aws.NetworkManager.ConnectAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransportAttachmentId = example.Id,
 *         EdgeLocation = example.EdgeLocation,
 *         Options = new Aws.NetworkManager.Inputs.ConnectAttachmentOptionsArgs
 *         {
 *             Protocol = "NO_ENCAP",
 *         },
 *     });
 *     var exampleConnectPeer = new Aws.NetworkManager.ConnectPeer("example", new()
 *     {
 *         ConnectAttachmentId = exampleConnectAttachment.Id,
 *         PeerAddress = "127.0.0.1",
 *         BgpOptions = new Aws.NetworkManager.Inputs.ConnectPeerBgpOptionsArgs
 *         {
 *             PeerAsn = 65000,
 *         },
 *         SubnetArn = test2.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Arn)
 * }
 * example, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * SubnetArns: toPulumiArray(splat0),
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * VpcArn: pulumi.Any(exampleAwsVpc.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * exampleConnectAttachment, err := networkmanager.NewConnectAttachment(ctx, "example", &networkmanager.ConnectAttachmentArgs{
 * CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * TransportAttachmentId: example.ID(),
 * EdgeLocation: example.EdgeLocation,
 * Options: &networkmanager.ConnectAttachmentOptionsArgs{
 * Protocol: pulumi.String("NO_ENCAP"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * _, err = networkmanager.NewConnectPeer(ctx, "example", &networkmanager.ConnectPeerArgs{
 * ConnectAttachmentId: exampleConnectAttachment.ID(),
 * PeerAddress: pulumi.String("127.0.0.1"),
 * BgpOptions: &networkmanager.ConnectPeerBgpOptionsArgs{
 * PeerAsn: pulumi.Int(65000),
 * },
 * SubnetArn: pulumi.Any(test2.Arn),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.ConnectAttachment;
 * import com.pulumi.aws.networkmanager.ConnectAttachmentArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs;
 * import com.pulumi.aws.networkmanager.ConnectPeer;
 * import com.pulumi.aws.networkmanager.ConnectPeerArgs;
 * import com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.stream().map(element -> element.arn()).collect(toList()))
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *         var exampleConnectAttachment = new ConnectAttachment("exampleConnectAttachment", ConnectAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transportAttachmentId(example.id())
 *             .edgeLocation(example.edgeLocation())
 *             .options(ConnectAttachmentOptionsArgs.builder()
 *                 .protocol("NO_ENCAP")
 *                 .build())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .connectAttachmentId(exampleConnectAttachment.id())
 *             .peerAddress("127.0.0.1")
 *             .bgpOptions(ConnectPeerBgpOptionsArgs.builder()
 *                 .peerAsn(65000)
 *                 .build())
 *             .subnetArn(test2.arn())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connect_peer` using the connect peer ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/connectPeer:ConnectPeer example connect-peer-061f3e96275db1acc
 * ```
 * @property bgpOptions The Connect peer BGP options.
 * @property connectAttachmentId The ID of the connection attachment.
 * @property coreNetworkAddress A Connect peer core network address.
 * @property insideCidrBlocks The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
 * @property peerAddress The Connect peer address.
 * The following arguments are optional:
 * @property subnetArn The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectPeerArgs(
    public val bgpOptions: Output<ConnectPeerBgpOptionsArgs>? = null,
    public val connectAttachmentId: Output<String>? = null,
    public val coreNetworkAddress: Output<String>? = null,
    public val insideCidrBlocks: Output<List<String>>? = null,
    public val peerAddress: Output<String>? = null,
    public val subnetArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.ConnectPeerArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.ConnectPeerArgs =
        com.pulumi.aws.networkmanager.ConnectPeerArgs.builder()
            .bgpOptions(bgpOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectAttachmentId(connectAttachmentId?.applyValue({ args0 -> args0 }))
            .coreNetworkAddress(coreNetworkAddress?.applyValue({ args0 -> args0 }))
            .insideCidrBlocks(insideCidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .peerAddress(peerAddress?.applyValue({ args0 -> args0 }))
            .subnetArn(subnetArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectPeerArgs].
 */
@PulumiTagMarker
public class ConnectPeerArgsBuilder internal constructor() {
    private var bgpOptions: Output<ConnectPeerBgpOptionsArgs>? = null

    private var connectAttachmentId: Output<String>? = null

    private var coreNetworkAddress: Output<String>? = null

    private var insideCidrBlocks: Output<List<String>>? = null

    private var peerAddress: Output<String>? = null

    private var subnetArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Connect peer BGP options.
     */
    @JvmName("jwdhiwchrqwfvlsd")
    public suspend fun bgpOptions(`value`: Output<ConnectPeerBgpOptionsArgs>) {
        this.bgpOptions = value
    }

    /**
     * @param value The ID of the connection attachment.
     */
    @JvmName("ujuahnoprcmrpcqu")
    public suspend fun connectAttachmentId(`value`: Output<String>) {
        this.connectAttachmentId = value
    }

    /**
     * @param value A Connect peer core network address.
     */
    @JvmName("cqlbsdrexnouyobr")
    public suspend fun coreNetworkAddress(`value`: Output<String>) {
        this.coreNetworkAddress = value
    }

    /**
     * @param value The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("guatimspaeqdskyu")
    public suspend fun insideCidrBlocks(`value`: Output<List<String>>) {
        this.insideCidrBlocks = value
    }

    @JvmName("apjdcggaouyphgwm")
    public suspend fun insideCidrBlocks(vararg values: Output<String>) {
        this.insideCidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("cbebgtdwhpjeudto")
    public suspend fun insideCidrBlocks(values: List<Output<String>>) {
        this.insideCidrBlocks = Output.all(values)
    }

    /**
     * @param value The Connect peer address.
     * The following arguments are optional:
     */
    @JvmName("psxatkrxjyrwyvax")
    public suspend fun peerAddress(`value`: Output<String>) {
        this.peerAddress = value
    }

    /**
     * @param value The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("pbiraxtvxrmrietf")
    public suspend fun subnetArn(`value`: Output<String>) {
        this.subnetArn = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("etjthhmliglfnnry")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Connect peer BGP options.
     */
    @JvmName("esjuxtxrbxrykmge")
    public suspend fun bgpOptions(`value`: ConnectPeerBgpOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpOptions = mapped
    }

    /**
     * @param argument The Connect peer BGP options.
     */
    @JvmName("execepxnvuuirbsu")
    public suspend fun bgpOptions(argument: suspend ConnectPeerBgpOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectPeerBgpOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpOptions = mapped
    }

    /**
     * @param value The ID of the connection attachment.
     */
    @JvmName("imcvddsypuobiwcy")
    public suspend fun connectAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectAttachmentId = mapped
    }

    /**
     * @param value A Connect peer core network address.
     */
    @JvmName("imdwffxfyhclkato")
    public suspend fun coreNetworkAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkAddress = mapped
    }

    /**
     * @param value The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("whjndcelpullibew")
    public suspend fun insideCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param values The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("dprlingjwctqfbjw")
    public suspend fun insideCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param value The Connect peer address.
     * The following arguments are optional:
     */
    @JvmName("yynafhjpnfdfrglo")
    public suspend fun peerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAddress = mapped
    }

    /**
     * @param value The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("mddvhcrvtsofcyeh")
    public suspend fun subnetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetArn = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pwntvfeowoidaskm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yesnryexlldrgxch")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectPeerArgs = ConnectPeerArgs(
        bgpOptions = bgpOptions,
        connectAttachmentId = connectAttachmentId,
        coreNetworkAddress = coreNetworkAddress,
        insideCidrBlocks = insideCidrBlocks,
        peerAddress = peerAddress,
        subnetArn = subnetArn,
        tags = tags,
    )
}
