@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.ConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a connection between two devices.
 * The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.Connection("example", {
 *     globalNetworkId: exampleAwsNetworkmanagerGlobalNetwork.id,
 *     deviceId: example1.id,
 *     connectedDeviceId: example2.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.Connection("example",
 *     global_network_id=example_aws_networkmanager_global_network["id"],
 *     device_id=example1["id"],
 *     connected_device_id=example2["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.Connection("example", new()
 *     {
 *         GlobalNetworkId = exampleAwsNetworkmanagerGlobalNetwork.Id,
 *         DeviceId = example1.Id,
 *         ConnectedDeviceId = example2.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewConnection(ctx, "example", &networkmanager.ConnectionArgs{
 * 			GlobalNetworkId:   pulumi.Any(exampleAwsNetworkmanagerGlobalNetwork.Id),
 * 			DeviceId:          pulumi.Any(example1.Id),
 * 			ConnectedDeviceId: pulumi.Any(example2.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.Connection;
 * import com.pulumi.aws.networkmanager.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .globalNetworkId(exampleAwsNetworkmanagerGlobalNetwork.id())
 *             .deviceId(example1.id())
 *             .connectedDeviceId(example2.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:Connection
 *     properties:
 *       globalNetworkId: ${exampleAwsNetworkmanagerGlobalNetwork.id}
 *       deviceId: ${example1.id}
 *       connectedDeviceId: ${example2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connection` using the connection ARN. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/connection:Connection example arn:aws:networkmanager::123456789012:device/global-network-0d47f6t230mz46dy4/connection-07f6fd08867abc123
 * ```
 * @property connectedDeviceId The ID of the second device in the connection.
 * @property connectedLinkId The ID of the link for the second device.
 * @property description A description of the connection.
 * @property deviceId The ID of the first device in the connection.
 * @property globalNetworkId The ID of the global network.
 * @property linkId The ID of the link for the first device.
 * @property tags Key-value tags for the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectionArgs(
    public val connectedDeviceId: Output<String>? = null,
    public val connectedLinkId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val deviceId: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val linkId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.ConnectionArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.ConnectionArgs =
        com.pulumi.aws.networkmanager.ConnectionArgs.builder()
            .connectedDeviceId(connectedDeviceId?.applyValue({ args0 -> args0 }))
            .connectedLinkId(connectedLinkId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceId(deviceId?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .linkId(linkId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var connectedDeviceId: Output<String>? = null

    private var connectedLinkId: Output<String>? = null

    private var description: Output<String>? = null

    private var deviceId: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var linkId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the second device in the connection.
     */
    @JvmName("tsnqsaxmkmgepqdp")
    public suspend fun connectedDeviceId(`value`: Output<String>) {
        this.connectedDeviceId = value
    }

    /**
     * @param value The ID of the link for the second device.
     */
    @JvmName("dlhmanvtgvmlhmth")
    public suspend fun connectedLinkId(`value`: Output<String>) {
        this.connectedLinkId = value
    }

    /**
     * @param value A description of the connection.
     */
    @JvmName("ndpytomyqxehyuxg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the first device in the connection.
     */
    @JvmName("kcxgihrnhfoyvswt")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("kfmhrbwwiyncmiio")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The ID of the link for the first device.
     */
    @JvmName("vmvjqrtjlfgqvrnk")
    public suspend fun linkId(`value`: Output<String>) {
        this.linkId = value
    }

    /**
     * @param value Key-value tags for the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sblqdocpjtgwtvtp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the second device in the connection.
     */
    @JvmName("vatrhiebnxhthtrv")
    public suspend fun connectedDeviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedDeviceId = mapped
    }

    /**
     * @param value The ID of the link for the second device.
     */
    @JvmName("rufybdujpguyapwi")
    public suspend fun connectedLinkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedLinkId = mapped
    }

    /**
     * @param value A description of the connection.
     */
    @JvmName("wsilqcbqydiuchwt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the first device in the connection.
     */
    @JvmName("ccehuobxcsfpxxil")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("xkmjoddlwvvltlva")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The ID of the link for the first device.
     */
    @JvmName("lngrsmcsubvorjuy")
    public suspend fun linkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkId = mapped
    }

    /**
     * @param value Key-value tags for the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mfjahyeswrrqtlfa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the connection. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hivivbnyxjvvytny")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        connectedDeviceId = connectedDeviceId,
        connectedLinkId = connectedLinkId,
        description = description,
        deviceId = deviceId,
        globalNetworkId = globalNetworkId,
        linkId = linkId,
        tags = tags,
    )
}
