@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.DeviceArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.DeviceAwsLocationArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.DeviceAwsLocationArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.DeviceLocationArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.DeviceLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a device in a global network. If you specify both a site ID and a location,
 * the location of the site is used for visualization in the Network Manager console.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.Device("example", {
 *     globalNetworkId: exampleAwsNetworkmanagerGlobalNetwork.id,
 *     siteId: exampleAwsNetworkmanagerSite.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.Device("example",
 *     global_network_id=example_aws_networkmanager_global_network["id"],
 *     site_id=example_aws_networkmanager_site["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.Device("example", new()
 *     {
 *         GlobalNetworkId = exampleAwsNetworkmanagerGlobalNetwork.Id,
 *         SiteId = exampleAwsNetworkmanagerSite.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewDevice(ctx, "example", &networkmanager.DeviceArgs{
 * 			GlobalNetworkId: pulumi.Any(exampleAwsNetworkmanagerGlobalNetwork.Id),
 * 			SiteId:          pulumi.Any(exampleAwsNetworkmanagerSite.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.Device;
 * import com.pulumi.aws.networkmanager.DeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Device("example", DeviceArgs.builder()
 *             .globalNetworkId(exampleAwsNetworkmanagerGlobalNetwork.id())
 *             .siteId(exampleAwsNetworkmanagerSite.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:Device
 *     properties:
 *       globalNetworkId: ${exampleAwsNetworkmanagerGlobalNetwork.id}
 *       siteId: ${exampleAwsNetworkmanagerSite.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_device` using the device ARN. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/device:Device example arn:aws:networkmanager::123456789012:device/global-network-0d47f6t230mz46dy4/device-07f6fd08867abc123
 * ```
 * @property awsLocation The AWS location of the device. Documented below.
 * @property description A description of the device.
 * @property globalNetworkId The ID of the global network.
 * @property location The location of the device. Documented below.
 * @property model The model of device.
 * @property serialNumber The serial number of the device.
 * @property siteId The ID of the site.
 * @property tags Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of device.
 * @property vendor The vendor of the device.
 */
public data class DeviceArgs(
    public val awsLocation: Output<DeviceAwsLocationArgs>? = null,
    public val description: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val location: Output<DeviceLocationArgs>? = null,
    public val model: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val siteId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val vendor: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.DeviceArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.DeviceArgs =
        com.pulumi.aws.networkmanager.DeviceArgs.builder()
            .awsLocation(awsLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .model(model?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .siteId(siteId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vendor(vendor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceArgs].
 */
@PulumiTagMarker
public class DeviceArgsBuilder internal constructor() {
    private var awsLocation: Output<DeviceAwsLocationArgs>? = null

    private var description: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var location: Output<DeviceLocationArgs>? = null

    private var model: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var siteId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var vendor: Output<String>? = null

    /**
     * @param value The AWS location of the device. Documented below.
     */
    @JvmName("fqihhrnseesywufc")
    public suspend fun awsLocation(`value`: Output<DeviceAwsLocationArgs>) {
        this.awsLocation = value
    }

    /**
     * @param value A description of the device.
     */
    @JvmName("pafwlihrhsrxvyll")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("duhkhtptsrnfnrki")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The location of the device. Documented below.
     */
    @JvmName("rsyrianscumgctln")
    public suspend fun location(`value`: Output<DeviceLocationArgs>) {
        this.location = value
    }

    /**
     * @param value The model of device.
     */
    @JvmName("hrldvamkdpvexgit")
    public suspend fun model(`value`: Output<String>) {
        this.model = value
    }

    /**
     * @param value The serial number of the device.
     */
    @JvmName("hrjwgxvsdjdgflss")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value The ID of the site.
     */
    @JvmName("sqhbkxjnhdumvqrt")
    public suspend fun siteId(`value`: Output<String>) {
        this.siteId = value
    }

    /**
     * @param value Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cklectibtetviwrq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of device.
     */
    @JvmName("flwvxjmwbkuposaa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The vendor of the device.
     */
    @JvmName("uptylkxevskylyte")
    public suspend fun vendor(`value`: Output<String>) {
        this.vendor = value
    }

    /**
     * @param value The AWS location of the device. Documented below.
     */
    @JvmName("yfbbsbkhrmxirobe")
    public suspend fun awsLocation(`value`: DeviceAwsLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsLocation = mapped
    }

    /**
     * @param argument The AWS location of the device. Documented below.
     */
    @JvmName("iplrjwburlmxirbr")
    public suspend fun awsLocation(argument: suspend DeviceAwsLocationArgsBuilder.() -> Unit) {
        val toBeMapped = DeviceAwsLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.awsLocation = mapped
    }

    /**
     * @param value A description of the device.
     */
    @JvmName("dtvtaigosicsuwpv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("iyklwjpohithrjtp")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The location of the device. Documented below.
     */
    @JvmName("enhoucwqpcvgvdod")
    public suspend fun location(`value`: DeviceLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param argument The location of the device. Documented below.
     */
    @JvmName("jpophbofjwgirhrf")
    public suspend fun location(argument: suspend DeviceLocationArgsBuilder.() -> Unit) {
        val toBeMapped = DeviceLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.location = mapped
    }

    /**
     * @param value The model of device.
     */
    @JvmName("ootrdtrgrglrscfj")
    public suspend fun model(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value The serial number of the device.
     */
    @JvmName("yemdhowmykuqmsqu")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value The ID of the site.
     */
    @JvmName("fnnnrrhkpvkulimj")
    public suspend fun siteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteId = mapped
    }

    /**
     * @param value Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gaourklhadrwlkos")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fpstvjdokldbgidl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of device.
     */
    @JvmName("inddsqktvnyflyss")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The vendor of the device.
     */
    @JvmName("uxnnebhafatdfela")
    public suspend fun vendor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendor = mapped
    }

    internal fun build(): DeviceArgs = DeviceArgs(
        awsLocation = awsLocation,
        description = description,
        globalNetworkId = globalNetworkId,
        location = location,
        model = model,
        serialNumber = serialNumber,
        siteId = siteId,
        tags = tags,
        type = type,
        vendor = vendor,
    )
}
