@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GlobalNetwork].
 */
@PulumiTagMarker
public class GlobalNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalNetworkArgs = GlobalNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalNetworkArgsBuilder.() -> Unit) {
        val builder = GlobalNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GlobalNetwork {
        val builtJavaResource = com.pulumi.aws.networkmanager.GlobalNetwork(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GlobalNetwork(builtJavaResource)
    }
}

/**
 * Provides a global network resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.GlobalNetwork("example", {description: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.GlobalNetwork("example", description="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.GlobalNetwork("example", new()
 *     {
 *         Description = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewGlobalNetwork(ctx, "example", &networkmanager.GlobalNetworkArgs{
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.GlobalNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalNetwork("example", GlobalNetworkArgs.builder()
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:GlobalNetwork
 *     properties:
 *       description: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_global_network` using the global network ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/globalNetwork:GlobalNetwork example global-network-0d47f6t230mz46dy4
 * ```
 */
public class GlobalNetwork internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.GlobalNetwork,
) : KotlinCustomResource(javaResource, GlobalNetworkMapper) {
    /**
     * Global Network Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the Global Network.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value tags for the Global Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object GlobalNetworkMapper : ResourceMapper<GlobalNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.GlobalNetwork::class == javaResource::class

    override fun map(javaResource: Resource): GlobalNetwork = GlobalNetwork(
        javaResource as
            com.pulumi.aws.networkmanager.GlobalNetwork,
    )
}

/**
 * @see [GlobalNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalNetwork].
 */
public suspend fun globalNetwork(
    name: String,
    block: suspend GlobalNetworkResourceBuilder.() -> Unit,
): GlobalNetwork {
    val builder = GlobalNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalNetwork(name: String): GlobalNetwork {
    val builder = GlobalNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
