@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.LinkArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.LinkBandwidthArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.LinkBandwidthArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a link for a site.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.Link("example", {
 *     globalNetworkId: exampleAwsNetworkmanagerGlobalNetwork.id,
 *     siteId: exampleAwsNetworkmanagerSite.id,
 *     bandwidth: {
 *         uploadSpeed: 10,
 *         downloadSpeed: 50,
 *     },
 *     providerName: "MegaCorp",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.Link("example",
 *     global_network_id=example_aws_networkmanager_global_network["id"],
 *     site_id=example_aws_networkmanager_site["id"],
 *     bandwidth={
 *         "upload_speed": 10,
 *         "download_speed": 50,
 *     },
 *     provider_name="MegaCorp")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.Link("example", new()
 *     {
 *         GlobalNetworkId = exampleAwsNetworkmanagerGlobalNetwork.Id,
 *         SiteId = exampleAwsNetworkmanagerSite.Id,
 *         Bandwidth = new Aws.NetworkManager.Inputs.LinkBandwidthArgs
 *         {
 *             UploadSpeed = 10,
 *             DownloadSpeed = 50,
 *         },
 *         ProviderName = "MegaCorp",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewLink(ctx, "example", &networkmanager.LinkArgs{
 * 			GlobalNetworkId: pulumi.Any(exampleAwsNetworkmanagerGlobalNetwork.Id),
 * 			SiteId:          pulumi.Any(exampleAwsNetworkmanagerSite.Id),
 * 			Bandwidth: &networkmanager.LinkBandwidthArgs{
 * 				UploadSpeed:   pulumi.Int(10),
 * 				DownloadSpeed: pulumi.Int(50),
 * 			},
 * 			ProviderName: pulumi.String("MegaCorp"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.Link;
 * import com.pulumi.aws.networkmanager.LinkArgs;
 * import com.pulumi.aws.networkmanager.inputs.LinkBandwidthArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .globalNetworkId(exampleAwsNetworkmanagerGlobalNetwork.id())
 *             .siteId(exampleAwsNetworkmanagerSite.id())
 *             .bandwidth(LinkBandwidthArgs.builder()
 *                 .uploadSpeed(10)
 *                 .downloadSpeed(50)
 *                 .build())
 *             .providerName("MegaCorp")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:Link
 *     properties:
 *       globalNetworkId: ${exampleAwsNetworkmanagerGlobalNetwork.id}
 *       siteId: ${exampleAwsNetworkmanagerSite.id}
 *       bandwidth:
 *         uploadSpeed: 10
 *         downloadSpeed: 50
 *       providerName: MegaCorp
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_link` using the link ARN. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/link:Link example arn:aws:networkmanager::123456789012:link/global-network-0d47f6t230mz46dy4/link-444555aaabbb11223
 * ```
 * @property bandwidth The upload speed and download speed in Mbps. Documented below.
 * @property description A description of the link.
 * @property globalNetworkId The ID of the global network.
 * @property providerName The provider of the link.
 * @property siteId The ID of the site.
 * @property tags Key-value tags for the link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of the link.
 */
public data class LinkArgs(
    public val bandwidth: Output<LinkBandwidthArgs>? = null,
    public val description: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val providerName: Output<String>? = null,
    public val siteId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.LinkArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.LinkArgs =
        com.pulumi.aws.networkmanager.LinkArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .siteId(siteId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkArgs].
 */
@PulumiTagMarker
public class LinkArgsBuilder internal constructor() {
    private var bandwidth: Output<LinkBandwidthArgs>? = null

    private var description: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var providerName: Output<String>? = null

    private var siteId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The upload speed and download speed in Mbps. Documented below.
     */
    @JvmName("echmljbmurknysmh")
    public suspend fun bandwidth(`value`: Output<LinkBandwidthArgs>) {
        this.bandwidth = value
    }

    /**
     * @param value A description of the link.
     */
    @JvmName("loerlwfcegjrriir")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("txctefmvaicytqhh")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The provider of the link.
     */
    @JvmName("wryurbspbheoukcg")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The ID of the site.
     */
    @JvmName("uepfpjwocvkrfqwb")
    public suspend fun siteId(`value`: Output<String>) {
        this.siteId = value
    }

    /**
     * @param value Key-value tags for the link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wmejdbevdbfadpeh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the link.
     */
    @JvmName("ndfntfcibnvwyanb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The upload speed and download speed in Mbps. Documented below.
     */
    @JvmName("ppuxqlnsidtbcgls")
    public suspend fun bandwidth(`value`: LinkBandwidthArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param argument The upload speed and download speed in Mbps. Documented below.
     */
    @JvmName("cnsjpfxbrelggtnd")
    public suspend fun bandwidth(argument: suspend LinkBandwidthArgsBuilder.() -> Unit) {
        val toBeMapped = LinkBandwidthArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bandwidth = mapped
    }

    /**
     * @param value A description of the link.
     */
    @JvmName("hgrwbgkghfsqmuvo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("enuqcnrmjiouivyj")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The provider of the link.
     */
    @JvmName("kblgmjxducgfvpkv")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The ID of the site.
     */
    @JvmName("ulwsftpjsxkbjoxd")
    public suspend fun siteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteId = mapped
    }

    /**
     * @param value Key-value tags for the link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vmlgoljtcvwyjqcn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ilctmsgvqukjbcre")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the link.
     */
    @JvmName("kcaknrpbjrhgdfut")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): LinkArgs = LinkArgs(
        bandwidth = bandwidth,
        description = description,
        globalNetworkId = globalNetworkId,
        providerName = providerName,
        siteId = siteId,
        tags = tags,
        type = type,
    )
}
