@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LinkAssociation].
 */
@PulumiTagMarker
public class LinkAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkAssociationArgs = LinkAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkAssociationArgsBuilder.() -> Unit) {
        val builder = LinkAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LinkAssociation {
        val builtJavaResource = com.pulumi.aws.networkmanager.LinkAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LinkAssociation(builtJavaResource)
    }
}

/**
 * Associates a link to a device.
 * A device can be associated to multiple links and a link can be associated to multiple devices.
 * The device and link must be in the same global network and the same site.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.LinkAssociation("example", {
 *     globalNetworkId: exampleAwsNetworkmanagerGlobalNetwork.id,
 *     linkId: exampleAwsNetworkmanagerLink.id,
 *     deviceId: exampleAwsNetworkmanagerDevice.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.LinkAssociation("example",
 *     global_network_id=example_aws_networkmanager_global_network["id"],
 *     link_id=example_aws_networkmanager_link["id"],
 *     device_id=example_aws_networkmanager_device["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.LinkAssociation("example", new()
 *     {
 *         GlobalNetworkId = exampleAwsNetworkmanagerGlobalNetwork.Id,
 *         LinkId = exampleAwsNetworkmanagerLink.Id,
 *         DeviceId = exampleAwsNetworkmanagerDevice.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewLinkAssociation(ctx, "example", &networkmanager.LinkAssociationArgs{
 * 			GlobalNetworkId: pulumi.Any(exampleAwsNetworkmanagerGlobalNetwork.Id),
 * 			LinkId:          pulumi.Any(exampleAwsNetworkmanagerLink.Id),
 * 			DeviceId:        pulumi.Any(exampleAwsNetworkmanagerDevice.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.LinkAssociation;
 * import com.pulumi.aws.networkmanager.LinkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LinkAssociation("example", LinkAssociationArgs.builder()
 *             .globalNetworkId(exampleAwsNetworkmanagerGlobalNetwork.id())
 *             .linkId(exampleAwsNetworkmanagerLink.id())
 *             .deviceId(exampleAwsNetworkmanagerDevice.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:LinkAssociation
 *     properties:
 *       globalNetworkId: ${exampleAwsNetworkmanagerGlobalNetwork.id}
 *       linkId: ${exampleAwsNetworkmanagerLink.id}
 *       deviceId: ${exampleAwsNetworkmanagerDevice.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_link_association` using the global network ID, link ID and device ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/linkAssociation:LinkAssociation example global-network-0d47f6t230mz46dy4,link-444555aaabbb11223,device-07f6fd08867abc123
 * ```
 */
public class LinkAssociation internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.LinkAssociation,
) : KotlinCustomResource(javaResource, LinkAssociationMapper) {
    /**
     * The ID of the device.
     */
    public val deviceId: Output<String>
        get() = javaResource.deviceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the global network.
     */
    public val globalNetworkId: Output<String>
        get() = javaResource.globalNetworkId().applyValue({ args0 -> args0 })

    /**
     * The ID of the link.
     */
    public val linkId: Output<String>
        get() = javaResource.linkId().applyValue({ args0 -> args0 })
}

public object LinkAssociationMapper : ResourceMapper<LinkAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.LinkAssociation::class == javaResource::class

    override fun map(javaResource: Resource): LinkAssociation = LinkAssociation(
        javaResource as
            com.pulumi.aws.networkmanager.LinkAssociation,
    )
}

/**
 * @see [LinkAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkAssociation].
 */
public suspend fun linkAssociation(
    name: String,
    block: suspend LinkAssociationResourceBuilder.() -> Unit,
): LinkAssociation {
    val builder = LinkAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkAssociation(name: String): LinkAssociation {
    val builder = LinkAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
