@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.LinkAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a link to a device.
 * A device can be associated to multiple links and a link can be associated to multiple devices.
 * The device and link must be in the same global network and the same site.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.LinkAssociation("example", {
 *     globalNetworkId: exampleAwsNetworkmanagerGlobalNetwork.id,
 *     linkId: exampleAwsNetworkmanagerLink.id,
 *     deviceId: exampleAwsNetworkmanagerDevice.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.LinkAssociation("example",
 *     global_network_id=example_aws_networkmanager_global_network["id"],
 *     link_id=example_aws_networkmanager_link["id"],
 *     device_id=example_aws_networkmanager_device["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.LinkAssociation("example", new()
 *     {
 *         GlobalNetworkId = exampleAwsNetworkmanagerGlobalNetwork.Id,
 *         LinkId = exampleAwsNetworkmanagerLink.Id,
 *         DeviceId = exampleAwsNetworkmanagerDevice.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewLinkAssociation(ctx, "example", &networkmanager.LinkAssociationArgs{
 * 			GlobalNetworkId: pulumi.Any(exampleAwsNetworkmanagerGlobalNetwork.Id),
 * 			LinkId:          pulumi.Any(exampleAwsNetworkmanagerLink.Id),
 * 			DeviceId:        pulumi.Any(exampleAwsNetworkmanagerDevice.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.LinkAssociation;
 * import com.pulumi.aws.networkmanager.LinkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LinkAssociation("example", LinkAssociationArgs.builder()
 *             .globalNetworkId(exampleAwsNetworkmanagerGlobalNetwork.id())
 *             .linkId(exampleAwsNetworkmanagerLink.id())
 *             .deviceId(exampleAwsNetworkmanagerDevice.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:LinkAssociation
 *     properties:
 *       globalNetworkId: ${exampleAwsNetworkmanagerGlobalNetwork.id}
 *       linkId: ${exampleAwsNetworkmanagerLink.id}
 *       deviceId: ${exampleAwsNetworkmanagerDevice.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_link_association` using the global network ID, link ID and device ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/linkAssociation:LinkAssociation example global-network-0d47f6t230mz46dy4,link-444555aaabbb11223,device-07f6fd08867abc123
 * ```
 * @property deviceId The ID of the device.
 * @property globalNetworkId The ID of the global network.
 * @property linkId The ID of the link.
 */
public data class LinkAssociationArgs(
    public val deviceId: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val linkId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.LinkAssociationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.LinkAssociationArgs =
        com.pulumi.aws.networkmanager.LinkAssociationArgs.builder()
            .deviceId(deviceId?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .linkId(linkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkAssociationArgs].
 */
@PulumiTagMarker
public class LinkAssociationArgsBuilder internal constructor() {
    private var deviceId: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var linkId: Output<String>? = null

    /**
     * @param value The ID of the device.
     */
    @JvmName("eqbovndcgbkvvqnh")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("flityvtcwcojtpop")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("ndpatrfbeumpxhmb")
    public suspend fun linkId(`value`: Output<String>) {
        this.linkId = value
    }

    /**
     * @param value The ID of the device.
     */
    @JvmName("hqmnvbitrxtowrqu")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("wqxxtukfyqucoefs")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("phrrcuvnbqafbmrt")
    public suspend fun linkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkId = mapped
    }

    internal fun build(): LinkAssociationArgs = LinkAssociationArgs(
        deviceId = deviceId,
        globalNetworkId = globalNetworkId,
        linkId = linkId,
    )
}
