@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getConnectionPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getConnectionsPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getCoreNetworkPolicyDocumentPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getDevicePlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getDevicesPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getGlobalNetworkPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getGlobalNetworksPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getLinkPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getLinksPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getSitePlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getSitesPlain
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionsPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionsPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicy
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentNetworkFunctionGroup
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentSegment
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentSegmentAction
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicePlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicePlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicesPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicesPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworkPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworkPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworksPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworksPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinkPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinkPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinksPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinksPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitePlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitePlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitesPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitesPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionsResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDeviceResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDevicesResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworkResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworksResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinkResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinksResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSiteResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSitesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionResult.Companion.toKotlin as getConnectionResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionsResult.Companion.toKotlin as getConnectionsResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentResult.Companion.toKotlin as getCoreNetworkPolicyDocumentResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDeviceResult.Companion.toKotlin as getDeviceResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDevicesResult.Companion.toKotlin as getDevicesResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworkResult.Companion.toKotlin as getGlobalNetworkResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworksResult.Companion.toKotlin as getGlobalNetworksResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinkResult.Companion.toKotlin as getLinkResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinksResult.Companion.toKotlin as getLinksResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSiteResult.Companion.toKotlin as getSiteResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSitesResult.Companion.toKotlin as getSitesResultToKotlin

public object NetworkmanagerFunctions {
    /**
     * Retrieve information about a connection.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getConnection({
     *     globalNetworkId: globalNetworkId,
     *     connectionId: connectionId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_connection(global_network_id=global_network_id,
     *     connection_id=connection_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetConnection.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *         ConnectionId = connectionId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.LookupConnection(ctx, &networkmanager.LookupConnectionArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 			ConnectionId:    connectionId,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getConnection(GetConnectionArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .connectionId(connectionId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getConnection
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     *         connectionId: ${connectionId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param connectionId ID of the specific connection to retrieve.
     * @param globalNetworkId ID of the Global Network of the connection to retrieve.
     * @param tags Key-value tags for the connection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(
        connectionId: String,
        globalNetworkId: String,
        tags: Map<String, String>? = null,
    ): GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            connectionId = connectionId,
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit): GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionResultToKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about connections.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getConnections({
     *     globalNetworkId: globalNetworkId,
     *     tags: {
     *         Env: "test",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_connections(global_network_id=global_network_id,
     *     tags={
     *         "Env": "test",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetConnections.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *         Tags =
     *         {
     *             { "Env", "test" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.GetConnections(ctx, &networkmanager.GetConnectionsArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 			Tags: map[string]interface{}{
     * 				"Env": "test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getConnections(GetConnectionsArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getConnections
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     *         tags:
     *           Env: test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getConnections.
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: GetConnectionsPlainArgs): GetConnectionsResult =
        getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getConnections].
     * @param deviceId ID of the device of the connections to retrieve.
     * @param globalNetworkId ID of the Global Network of the connections to retrieve.
     * @param tags Restricts the list to the connections with these tags.
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(
        deviceId: String? = null,
        globalNetworkId: String,
        tags: Map<String, String>? = null,
    ): GetConnectionsResult {
        val argument = GetConnectionsPlainArgs(
            deviceId = deviceId,
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnections].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetConnectionsPlainArgs].
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: suspend GetConnectionsPlainArgsBuilder.() -> Unit): GetConnectionsResult {
        val builder = GetConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionsResultToKotlin(getConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Generates a Core Network policy document in JSON format for use with resources that expect core network policy documents such as `awscc_networkmanager_core_network`. It follows the API definition from the [core-network-policy documentation](https://docs.aws.amazon.com/vpc/latest/cloudwan/cloudwan-policies-json.html).
     * Using this data source to generate policy documents is *optional*. It is also valid to use literal JSON strings in your configuration or to use the `file` interpolation function to read a raw JSON policy document from a file.
     * ## Example Usage
     * ### Basic Example
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.networkmanager.getCoreNetworkPolicyDocument({
     *     coreNetworkConfigurations: [{
     *         vpnEcmpSupport: false,
     *         asnRanges: ["64512-64555"],
     *         edgeLocations: [
     *             {
     *                 location: "us-east-1",
     *                 asn: "64512",
     *             },
     *             {
     *                 location: "eu-central-1",
     *                 asn: "64513",
     *             },
     *         ],
     *     }],
     *     segments: [
     *         {
     *             name: "shared",
     *             description: "Segment for shared services",
     *             requireAttachmentAcceptance: true,
     *         },
     *         {
     *             name: "prod",
     *             description: "Segment for prod services",
     *             requireAttachmentAcceptance: true,
     *         },
     *     ],
     *     segmentActions: [{
     *         action: "share",
     *         mode: "attachment-route",
     *         segment: "shared",
     *         shareWiths: ["*"],
     *     }],
     *     attachmentPolicies: [
     *         {
     *             ruleNumber: 100,
     *             conditionLogic: "or",
     *             conditions: [{
     *                 type: "tag-value",
     *                 operator: "equals",
     *                 key: "segment",
     *                 value: "shared",
     *             }],
     *             action: {
     *                 associationMethod: "constant",
     *                 segment: "shared",
     *             },
     *         },
     *         {
     *             ruleNumber: 200,
     *             conditionLogic: "or",
     *             conditions: [{
     *                 type: "tag-value",
     *                 operator: "equals",
     *                 key: "segment",
     *                 value: "prod",
     *             }],
     *             action: {
     *                 associationMethod: "constant",
     *                 segment: "prod",
     *             },
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.networkmanager.get_core_network_policy_document(core_network_configurations=[{
     *         "vpn_ecmp_support": False,
     *         "asn_ranges": ["64512-64555"],
     *         "edge_locations": [
     *             {
     *                 "location": "us-east-1",
     *                 "asn": "64512",
     *             },
     *             {
     *                 "location": "eu-central-1",
     *                 "asn": "64513",
     *             },
     *         ],
     *     }],
     *     segments=[
     *         {
     *             "name": "shared",
     *             "description": "Segment for shared services",
     *             "require_attachment_acceptance": True,
     *         },
     *         {
     *             "name": "prod",
     *             "description": "Segment for prod services",
     *             "require_attachment_acceptance": True,
     *         },
     *     ],
     *     segment_actions=[{
     *         "action": "share",
     *         "mode": "attachment-route",
     *         "segment": "shared",
     *         "share_withs": ["*"],
     *     }],
     *     attachment_policies=[
     *         {
     *             "rule_number": 100,
     *             "condition_logic": "or",
     *             "conditions": [{
     *                 "type": "tag-value",
     *                 "operator": "equals",
     *                 "key": "segment",
     *                 "value": "shared",
     *             }],
     *             "action": {
     *                 "association_method": "constant",
     *                 "segment": "shared",
     *             },
     *         },
     *         {
     *             "rule_number": 200,
     *             "condition_logic": "or",
     *             "conditions": [{
     *                 "type": "tag-value",
     *                 "operator": "equals",
     *                 "key": "segment",
     *                 "value": "prod",
     *             }],
     *             "action": {
     *                 "association_method": "constant",
     *                 "segment": "prod",
     *             },
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.NetworkManager.GetCoreNetworkPolicyDocument.Invoke(new()
     *     {
     *         CoreNetworkConfigurations = new[]
     *         {
     *             new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationInputArgs
     *             {
     *                 VpnEcmpSupport = false,
     *                 AsnRanges = new[]
     *                 {
     *                     "64512-64555",
     *                 },
     *                 EdgeLocations = new[]
     *                 {
     *                     new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationInputArgs
     *                     {
     *                         Location = "us-east-1",
     *                         Asn = "64512",
     *                     },
     *                     new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationInputArgs
     *                     {
     *                         Location = "eu-central-1",
     *                         Asn = "64513",
     *                     },
     *                 },
     *             },
     *         },
     *         Segments = new[]
     *         {
     *             new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentSegmentInputArgs
     *             {
     *                 Name = "shared",
     *                 Description = "Segment for shared services",
     *                 RequireAttachmentAcceptance = true,
     *             },
     *             new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentSegmentInputArgs
     *             {
     *                 Name = "prod",
     *                 Description = "Segment for prod services",
     *                 RequireAttachmentAcceptance = true,
     *             },
     *         },
     *         SegmentActions = new[]
     *         {
     *             new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentSegmentActionInputArgs
     *             {
     *                 Action = "share",
     *                 Mode = "attachment-route",
     *                 Segment = "shared",
     *                 ShareWiths = new[]
     *                 {
     *                     "*",
     *                 },
     *             },
     *         },
     *         AttachmentPolicies = new[]
     *         {
     *             new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyInputArgs
     *             {
     *                 RuleNumber = 100,
     *                 ConditionLogic = "or",
     *                 Conditions = new[]
     *                 {
     *                     new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyConditionInputArgs
     *                     {
     *                         Type = "tag-value",
     *                         Operator = "equals",
     *                         Key = "segment",
     *                         Value = "shared",
     *                     },
     *                 },
     *                 Action = new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyActionInputArgs
     *                 {
     *                     AssociationMethod = "constant",
     *                     Segment = "shared",
     *                 },
     *             },
     *             new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyInputArgs
     *             {
     *                 RuleNumber = 200,
     *                 ConditionLogic = "or",
     *                 Conditions = new[]
     *                 {
     *                     new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyConditionInputArgs
     *                     {
     *                         Type = "tag-value",
     *                         Operator = "equals",
     *                         Key = "segment",
     *                         Value = "prod",
     *                     },
     *                 },
     *                 Action = new Aws.NetworkManager.Inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyActionInputArgs
     *                 {
     *                     AssociationMethod = "constant",
     *                     Segment = "prod",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.GetCoreNetworkPolicyDocument(ctx, &networkmanager.GetCoreNetworkPolicyDocumentArgs{
     * 			CoreNetworkConfigurations: []networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration{
     * 				{
     * 					VpnEcmpSupport: pulumi.BoolRef(false),
     * 					AsnRanges: []string{
     * 						"64512-64555",
     * 					},
     * 					EdgeLocations: []networkmanager.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation{
     * 						{
     * 							Location: "us-east-1",
     * 							Asn:      pulumi.StringRef("64512"),
     * 						},
     * 						{
     * 							Location: "eu-central-1",
     * 							Asn:      pulumi.StringRef("64513"),
     * 						},
     * 					},
     * 				},
     * 			},
     * 			Segments: []networkmanager.GetCoreNetworkPolicyDocumentSegment{
     * 				{
     * 					Name:                        "shared",
     * 					Description:                 pulumi.StringRef("Segment for shared services"),
     * 					RequireAttachmentAcceptance: pulumi.BoolRef(true),
     * 				},
     * 				{
     * 					Name:                        "prod",
     * 					Description:                 pulumi.StringRef("Segment for prod services"),
     * 					RequireAttachmentAcceptance: pulumi.BoolRef(true),
     * 				},
     * 			},
     * 			SegmentActions: []networkmanager.GetCoreNetworkPolicyDocumentSegmentAction{
     * 				{
     * 					Action:  "share",
     * 					Mode:    pulumi.StringRef("attachment-route"),
     * 					Segment: "shared",
     * 					ShareWiths: []string{
     * 						"*",
     * 					},
     * 				},
     * 			},
     * 			AttachmentPolicies: []networkmanager.GetCoreNetworkPolicyDocumentAttachmentPolicy{
     * 				{
     * 					RuleNumber:     100,
     * 					ConditionLogic: pulumi.StringRef("or"),
     * 					Conditions: []networkmanager.GetCoreNetworkPolicyDocumentAttachmentPolicyCondition{
     * 						{
     * 							Type:     "tag-value",
     * 							Operator: pulumi.StringRef("equals"),
     * 							Key:      pulumi.StringRef("segment"),
     * 							Value:    pulumi.StringRef("shared"),
     * 						},
     * 					},
     * 					Action: {
     * 						AssociationMethod: pulumi.StringRef("constant"),
     * 						Segment:           pulumi.StringRef("shared"),
     * 					},
     * 				},
     * 				{
     * 					RuleNumber:     200,
     * 					ConditionLogic: pulumi.StringRef("or"),
     * 					Conditions: []networkmanager.GetCoreNetworkPolicyDocumentAttachmentPolicyCondition{
     * 						{
     * 							Type:     "tag-value",
     * 							Operator: pulumi.StringRef("equals"),
     * 							Key:      pulumi.StringRef("segment"),
     * 							Value:    pulumi.StringRef("prod"),
     * 						},
     * 					},
     * 					Action: {
     * 						AssociationMethod: pulumi.StringRef("constant"),
     * 						Segment:           pulumi.StringRef("prod"),
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
     *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
     *                 .vpnEcmpSupport(false)
     *                 .asnRanges("64512-64555")
     *                 .edgeLocations(
     *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
     *                         .location("us-east-1")
     *                         .asn(64512)
     *                         .build(),
     *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
     *                         .location("eu-central-1")
     *                         .asn(64513)
     *                         .build())
     *                 .build())
     *             .segments(
     *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
     *                     .name("shared")
     *                     .description("Segment for shared services")
     *                     .requireAttachmentAcceptance(true)
     *                     .build(),
     *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
     *                     .name("prod")
     *                     .description("Segment for prod services")
     *                     .requireAttachmentAcceptance(true)
     *                     .build())
     *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
     *                 .action("share")
     *                 .mode("attachment-route")
     *                 .segment("shared")
     *                 .shareWiths("*")
     *                 .build())
     *             .attachmentPolicies(
     *                 GetCoreNetworkPolicyDocumentAttachmentPolicyArgs.builder()
     *                     .ruleNumber(100)
     *                     .conditionLogic("or")
     *                     .conditions(GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs.builder()
     *                         .type("tag-value")
     *                         .operator("equals")
     *                         .key("segment")
     *                         .value("shared")
     *                         .build())
     *                     .action(GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs.builder()
     *                         .associationMethod("constant")
     *                         .segment("shared")
     *                         .build())
     *                     .build(),
     *                 GetCoreNetworkPolicyDocumentAttachmentPolicyArgs.builder()
     *                     .ruleNumber(200)
     *                     .conditionLogic("or")
     *                     .conditions(GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs.builder()
     *                         .type("tag-value")
     *                         .operator("equals")
     *                         .key("segment")
     *                         .value("prod")
     *                         .build())
     *                     .action(GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs.builder()
     *                         .associationMethod("constant")
     *                         .segment("prod")
     *                         .build())
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:networkmanager:getCoreNetworkPolicyDocument
     *       Arguments:
     *         coreNetworkConfigurations:
     *           - vpnEcmpSupport: false
     *             asnRanges:
     *               - 64512-64555
     *             edgeLocations:
     *               - location: us-east-1
     *                 asn: 64512
     *               - location: eu-central-1
     *                 asn: 64513
     *         segments:
     *           - name: shared
     *             description: Segment for shared services
     *             requireAttachmentAcceptance: true
     *           - name: prod
     *             description: Segment for prod services
     *             requireAttachmentAcceptance: true
     *         segmentActions:
     *           - action: share
     *             mode: attachment-route
     *             segment: shared
     *             shareWiths:
     *               - '*'
     *         attachmentPolicies:
     *           - ruleNumber: 100
     *             conditionLogic: or
     *             conditions:
     *               - type: tag-value
     *                 operator: equals
     *                 key: segment
     *                 value: shared
     *             action:
     *               associationMethod: constant
     *               segment: shared
     *           - ruleNumber: 200
     *             conditionLogic: or
     *             conditions:
     *               - type: tag-value
     *                 operator: equals
     *                 key: segment
     *                 value: prod
     *             action:
     *               associationMethod: constant
     *               segment: prod
     * ```
     * <!--End PulumiCodeChooser -->
     * `data.aws_networkmanager_core_network_policy_document.test.json` will evaluate to:
     * ```json
     * {
     *   "version": "2021.12",
     *   "core-network-configuration": {
     *     "asn-ranges": [
     *       "64512-64555"
     *     ],
     *     "vpn-ecmp-support": false,
     *     "edge-locations": [
     *       {
     *         "location": "us-east-1",
     *         "asn": 64512
     *       },
     *       {
     *         "location": "eu-central-1",
     *         "asn": 64513
     *       }
     *     ]
     *   },
     *   "segments": [
     *     {
     *       "name": "shared",
     *       "description": "Segment for shared services",
     *       "require-attachment-acceptance": true
     *     },
     *     {
     *       "name": "prod",
     *       "description": "Segment for prod services",
     *       "require-attachment-acceptance": true
     *     }
     *   ],
     *   "attachment-policies": [
     *     {
     *       "rule-number": 100,
     *       "action": {
     *         "association-method": "constant",
     *         "segment": "shared"
     *       },
     *       "conditions": [
     *         {
     *           "type": "tag-value",
     *           "operator": "equals",
     *           "key": "segment",
     *           "value": "shared"
     *         }
     *       ],
     *       "condition-logic": "or"
     *     },
     *     {
     *       "rule-number": 200,
     *       "action": {
     *         "association-method": "constant",
     *         "segment": "prod"
     *       },
     *       "conditions": [
     *         {
     *           "type": "tag-value",
     *           "operator": "equals",
     *           "key": "segment",
     *           "value": "prod"
     *         }
     *       ],
     *       "condition-logic": "or"
     *     }
     *   ],
     *   "segment-actions": [
     *     {
     *       "action": "share",
     *       "mode": "attachment-route",
     *       "segment": "shared",
     *       "share-with": "*"
     *     }
     *   ]
     * }
     * ```
     * @param argument A collection of arguments for invoking getCoreNetworkPolicyDocument.
     * @return A collection of values returned by getCoreNetworkPolicyDocument.
     */
    public suspend fun getCoreNetworkPolicyDocument(argument: GetCoreNetworkPolicyDocumentPlainArgs): GetCoreNetworkPolicyDocumentResult =
        getCoreNetworkPolicyDocumentResultToKotlin(getCoreNetworkPolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getCoreNetworkPolicyDocument].
     * @param attachmentPolicies In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
     * @param coreNetworkConfigurations The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
     * @param networkFunctionGroups Block argument that defines the service insertion actions you want to include. Detailed below.
     * @param segmentActions A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     * @param segments Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     * @param version
     * @return A collection of values returned by getCoreNetworkPolicyDocument.
     */
    public suspend fun getCoreNetworkPolicyDocument(
        attachmentPolicies: List<GetCoreNetworkPolicyDocumentAttachmentPolicy>? = null,
        coreNetworkConfigurations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfiguration>,
        networkFunctionGroups: List<GetCoreNetworkPolicyDocumentNetworkFunctionGroup>? = null,
        segmentActions: List<GetCoreNetworkPolicyDocumentSegmentAction>? = null,
        segments: List<GetCoreNetworkPolicyDocumentSegment>,
        version: String? = null,
    ): GetCoreNetworkPolicyDocumentResult {
        val argument = GetCoreNetworkPolicyDocumentPlainArgs(
            attachmentPolicies = attachmentPolicies,
            coreNetworkConfigurations = coreNetworkConfigurations,
            networkFunctionGroups = networkFunctionGroups,
            segmentActions = segmentActions,
            segments = segments,
            version = version,
        )
        return getCoreNetworkPolicyDocumentResultToKotlin(getCoreNetworkPolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getCoreNetworkPolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetCoreNetworkPolicyDocumentPlainArgs].
     * @return A collection of values returned by getCoreNetworkPolicyDocument.
     */
    public suspend fun getCoreNetworkPolicyDocument(argument: suspend GetCoreNetworkPolicyDocumentPlainArgsBuilder.() -> Unit): GetCoreNetworkPolicyDocumentResult {
        val builder = GetCoreNetworkPolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCoreNetworkPolicyDocumentResultToKotlin(getCoreNetworkPolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a device.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetDeviceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getDevice(GetDeviceArgs.builder()
     *             .globalNetworkIdId(globalNetworkId)
     *             .deviceId(deviceId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getDevice
     *       Arguments:
     *         globalNetworkIdId: ${globalNetworkId}
     *         deviceId: ${deviceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDevice.
     * @return A collection of values returned by getDevice.
     */
    public suspend fun getDevice(argument: GetDevicePlainArgs): GetDeviceResult =
        getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())

    /**
     * @see [getDevice].
     * @param deviceId ID of the device.
     * @param globalNetworkId ID of the global network.
     * @param tags Key-value tags for the device.
     * @return A collection of values returned by getDevice.
     */
    public suspend fun getDevice(
        deviceId: String,
        globalNetworkId: String,
        tags: Map<String, String>? = null,
    ): GetDeviceResult {
        val argument = GetDevicePlainArgs(
            deviceId = deviceId,
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDevice].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetDevicePlainArgs].
     * @return A collection of values returned by getDevice.
     */
    public suspend fun getDevice(argument: suspend GetDevicePlainArgsBuilder.() -> Unit): GetDeviceResult {
        val builder = GetDevicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeviceResultToKotlin(getDevicePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about devices.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getDevices({
     *     globalNetworkId: globalNetworkId,
     *     tags: {
     *         Env: "test",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_devices(global_network_id=global_network_id,
     *     tags={
     *         "Env": "test",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetDevices.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *         Tags =
     *         {
     *             { "Env", "test" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.GetDevices(ctx, &networkmanager.GetDevicesArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 			Tags: map[string]interface{}{
     * 				"Env": "test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetDevicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getDevices(GetDevicesArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getDevices
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     *         tags:
     *           Env: test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDevices.
     * @return A collection of values returned by getDevices.
     */
    public suspend fun getDevices(argument: GetDevicesPlainArgs): GetDevicesResult =
        getDevicesResultToKotlin(getDevicesPlain(argument.toJava()).await())

    /**
     * @see [getDevices].
     * @param globalNetworkId ID of the Global Network of the devices to retrieve.
     * @param siteId ID of the site of the devices to retrieve.
     * @param tags Restricts the list to the devices with these tags.
     * @return A collection of values returned by getDevices.
     */
    public suspend fun getDevices(
        globalNetworkId: String,
        siteId: String? = null,
        tags: Map<String, String>? = null,
    ): GetDevicesResult {
        val argument = GetDevicesPlainArgs(
            globalNetworkId = globalNetworkId,
            siteId = siteId,
            tags = tags,
        )
        return getDevicesResultToKotlin(getDevicesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDevices].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetDevicesPlainArgs].
     * @return A collection of values returned by getDevices.
     */
    public suspend fun getDevices(argument: suspend GetDevicesPlainArgsBuilder.() -> Unit): GetDevicesResult {
        val builder = GetDevicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDevicesResultToKotlin(getDevicesPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a global network.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getGlobalNetwork({
     *     globalNetworkId: globalNetworkId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_global_network(global_network_id=global_network_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetGlobalNetwork.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.LookupGlobalNetwork(ctx, &networkmanager.LookupGlobalNetworkArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetGlobalNetworkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getGlobalNetwork(GetGlobalNetworkArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getGlobalNetwork
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGlobalNetwork.
     * @return A collection of values returned by getGlobalNetwork.
     */
    public suspend fun getGlobalNetwork(argument: GetGlobalNetworkPlainArgs): GetGlobalNetworkResult =
        getGlobalNetworkResultToKotlin(getGlobalNetworkPlain(argument.toJava()).await())

    /**
     * @see [getGlobalNetwork].
     * @param globalNetworkId ID of the specific global network to retrieve.
     * @param tags Map of resource tags.
     * @return A collection of values returned by getGlobalNetwork.
     */
    public suspend fun getGlobalNetwork(globalNetworkId: String, tags: Map<String, String>? = null): GetGlobalNetworkResult {
        val argument = GetGlobalNetworkPlainArgs(
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getGlobalNetworkResultToKotlin(getGlobalNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetGlobalNetworkPlainArgs].
     * @return A collection of values returned by getGlobalNetwork.
     */
    public suspend fun getGlobalNetwork(argument: suspend GetGlobalNetworkPlainArgsBuilder.() -> Unit): GetGlobalNetworkResult {
        val builder = GetGlobalNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalNetworkResultToKotlin(getGlobalNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about global networks.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getGlobalNetworks({
     *     tags: {
     *         Env: "test",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_global_networks(tags={
     *     "Env": "test",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetGlobalNetworks.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "Env", "test" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.GetGlobalNetworks(ctx, &networkmanager.GetGlobalNetworksArgs{
     * 			Tags: map[string]interface{}{
     * 				"Env": "test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetGlobalNetworksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getGlobalNetworks(GetGlobalNetworksArgs.builder()
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getGlobalNetworks
     *       Arguments:
     *         tags:
     *           Env: test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGlobalNetworks.
     * @return A collection of values returned by getGlobalNetworks.
     */
    public suspend fun getGlobalNetworks(argument: GetGlobalNetworksPlainArgs): GetGlobalNetworksResult =
        getGlobalNetworksResultToKotlin(getGlobalNetworksPlain(argument.toJava()).await())

    /**
     * @see [getGlobalNetworks].
     * @param tags Restricts the list to the global networks with these tags.
     * @return A collection of values returned by getGlobalNetworks.
     */
    public suspend fun getGlobalNetworks(tags: Map<String, String>? = null): GetGlobalNetworksResult {
        val argument = GetGlobalNetworksPlainArgs(
            tags = tags,
        )
        return getGlobalNetworksResultToKotlin(getGlobalNetworksPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalNetworks].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetGlobalNetworksPlainArgs].
     * @return A collection of values returned by getGlobalNetworks.
     */
    public suspend fun getGlobalNetworks(argument: suspend GetGlobalNetworksPlainArgsBuilder.() -> Unit): GetGlobalNetworksResult {
        val builder = GetGlobalNetworksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalNetworksResultToKotlin(getGlobalNetworksPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a link.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getLink({
     *     globalNetworkId: globalNetworkId,
     *     linkId: linkId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_link(global_network_id=global_network_id,
     *     link_id=link_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetLink.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *         LinkId = linkId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.LookupLink(ctx, &networkmanager.LookupLinkArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 			LinkId:          linkId,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetLinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getLink(GetLinkArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .linkId(linkId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getLink
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     *         linkId: ${linkId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLink.
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: GetLinkPlainArgs): GetLinkResult =
        getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())

    /**
     * @see [getLink].
     * @param globalNetworkId ID of the Global Network of the link to retrieve.
     * @param linkId ID of the specific link to retrieve.
     * @param tags Key-value tags for the link.
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(
        globalNetworkId: String,
        linkId: String,
        tags: Map<String, String>? = null,
    ): GetLinkResult {
        val argument = GetLinkPlainArgs(
            globalNetworkId = globalNetworkId,
            linkId = linkId,
            tags = tags,
        )
        return getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getLink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetLinkPlainArgs].
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: suspend GetLinkPlainArgsBuilder.() -> Unit): GetLinkResult {
        val builder = GetLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkResultToKotlin(getLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about link.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getLinks({
     *     globalNetworkId: globalNetworkId,
     *     tags: {
     *         Env: "test",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_links(global_network_id=global_network_id,
     *     tags={
     *         "Env": "test",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetLinks.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *         Tags =
     *         {
     *             { "Env", "test" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.GetLinks(ctx, &networkmanager.GetLinksArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 			Tags: map[string]interface{}{
     * 				"Env": "test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetLinksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getLinks(GetLinksArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getLinks
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     *         tags:
     *           Env: test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLinks.
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(argument: GetLinksPlainArgs): GetLinksResult =
        getLinksResultToKotlin(getLinksPlain(argument.toJava()).await())

    /**
     * @see [getLinks].
     * @param globalNetworkId ID of the Global Network of the links to retrieve.
     * @param providerName Link provider to retrieve.
     * @param siteId ID of the site of the links to retrieve.
     * @param tags Restricts the list to the links with these tags.
     * @param type Link type to retrieve.
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(
        globalNetworkId: String,
        providerName: String? = null,
        siteId: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
    ): GetLinksResult {
        val argument = GetLinksPlainArgs(
            globalNetworkId = globalNetworkId,
            providerName = providerName,
            siteId = siteId,
            tags = tags,
            type = type,
        )
        return getLinksResultToKotlin(getLinksPlain(argument.toJava()).await())
    }

    /**
     * @see [getLinks].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetLinksPlainArgs].
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(argument: suspend GetLinksPlainArgsBuilder.() -> Unit): GetLinksResult {
        val builder = GetLinksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinksResultToKotlin(getLinksPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a site.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getSite({
     *     globalNetworkId: globalNetworkId,
     *     siteId: siteId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_site(global_network_id=global_network_id,
     *     site_id=site_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetSite.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *         SiteId = siteId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.LookupSite(ctx, &networkmanager.LookupSiteArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 			SiteId:          siteId,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetSiteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getSite(GetSiteArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .siteId(siteId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getSite
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     *         siteId: ${siteId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSite.
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(argument: GetSitePlainArgs): GetSiteResult =
        getSiteResultToKotlin(getSitePlain(argument.toJava()).await())

    /**
     * @see [getSite].
     * @param globalNetworkId ID of the Global Network of the site to retrieve.
     * @param siteId ID of the specific site to retrieve.
     * @param tags Key-value tags for the Site.
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(
        globalNetworkId: String,
        siteId: String,
        tags: Map<String, String>? = null,
    ): GetSiteResult {
        val argument = GetSitePlainArgs(
            globalNetworkId = globalNetworkId,
            siteId = siteId,
            tags = tags,
        )
        return getSiteResultToKotlin(getSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getSite].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetSitePlainArgs].
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(argument: suspend GetSitePlainArgsBuilder.() -> Unit): GetSiteResult {
        val builder = GetSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteResultToKotlin(getSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about sites.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.networkmanager.getSites({
     *     globalNetworkId: globalNetworkId,
     *     tags: {
     *         Env: "test",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.networkmanager.get_sites(global_network_id=global_network_id,
     *     tags={
     *         "Env": "test",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.NetworkManager.GetSites.Invoke(new()
     *     {
     *         GlobalNetworkId = globalNetworkId,
     *         Tags =
     *         {
     *             { "Env", "test" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := networkmanager.GetSites(ctx, &networkmanager.GetSitesArgs{
     * 			GlobalNetworkId: globalNetworkId,
     * 			Tags: map[string]interface{}{
     * 				"Env": "test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetSitesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getSites(GetSitesArgs.builder()
     *             .globalNetworkId(globalNetworkId)
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:networkmanager:getSites
     *       Arguments:
     *         globalNetworkId: ${globalNetworkId}
     *         tags:
     *           Env: test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSites.
     * @return A collection of values returned by getSites.
     */
    public suspend fun getSites(argument: GetSitesPlainArgs): GetSitesResult =
        getSitesResultToKotlin(getSitesPlain(argument.toJava()).await())

    /**
     * @see [getSites].
     * @param globalNetworkId ID of the Global Network of the sites to retrieve.
     * @param tags Restricts the list to the sites with these tags.
     * @return A collection of values returned by getSites.
     */
    public suspend fun getSites(globalNetworkId: String, tags: Map<String, String>? = null): GetSitesResult {
        val argument = GetSitesPlainArgs(
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getSitesResultToKotlin(getSitesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSites].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetSitesPlainArgs].
     * @return A collection of values returned by getSites.
     */
    public suspend fun getSites(argument: suspend GetSitesPlainArgsBuilder.() -> Unit): GetSitesResult {
        val builder = GetSitesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSitesResultToKotlin(getSitesPlain(builtArgument.toJava()).await())
    }
}
