@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.SiteArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.SiteLocationArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.SiteLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a site in a global network.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.GlobalNetwork("example", {});
 * const exampleSite = new aws.networkmanager.Site("example", {globalNetworkId: example.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.GlobalNetwork("example")
 * example_site = aws.networkmanager.Site("example", global_network_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.GlobalNetwork("example");
 *     var exampleSite = new Aws.NetworkManager.Site("example", new()
 *     {
 *         GlobalNetworkId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := networkmanager.NewGlobalNetwork(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = networkmanager.NewSite(ctx, "example", &networkmanager.SiteArgs{
 * 			GlobalNetworkId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.Site;
 * import com.pulumi.aws.networkmanager.SiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalNetwork("example");
 *         var exampleSite = new Site("exampleSite", SiteArgs.builder()
 *             .globalNetworkId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:GlobalNetwork
 *   exampleSite:
 *     type: aws:networkmanager:Site
 *     name: example
 *     properties:
 *       globalNetworkId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_site` using the site ARN. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/site:Site example arn:aws:networkmanager::123456789012:site/global-network-0d47f6t230mz46dy4/site-444555aaabbb11223
 * ```
 * @property description Description of the Site.
 * @property globalNetworkId The ID of the Global Network to create the site in.
 * @property location The site location as documented below.
 * @property tags Key-value tags for the Site. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SiteArgs(
    public val description: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val location: Output<SiteLocationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.SiteArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.SiteArgs =
        com.pulumi.aws.networkmanager.SiteArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SiteArgs].
 */
@PulumiTagMarker
public class SiteArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var location: Output<SiteLocationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the Site.
     */
    @JvmName("vtxujljjcjkluxis")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Global Network to create the site in.
     */
    @JvmName("pgqwaghnxexxbptc")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The site location as documented below.
     */
    @JvmName("xiwbiyvevstlvtcc")
    public suspend fun location(`value`: Output<SiteLocationArgs>) {
        this.location = value
    }

    /**
     * @param value Key-value tags for the Site. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fbifassabcsihtng")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the Site.
     */
    @JvmName("wpudinxgrnqpsjqn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Global Network to create the site in.
     */
    @JvmName("fpvlcvoahgcxgfsp")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The site location as documented below.
     */
    @JvmName("hbsdxdywreulyhiy")
    public suspend fun location(`value`: SiteLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param argument The site location as documented below.
     */
    @JvmName("ndvegmyrmdgopbvb")
    public suspend fun location(argument: suspend SiteLocationArgsBuilder.() -> Unit) {
        val toBeMapped = SiteLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.location = mapped
    }

    /**
     * @param value Key-value tags for the Site. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sgpbqpgyaqcukxfg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the Site. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("chupknlggfnrhtwo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SiteArgs = SiteArgs(
        description = description,
        globalNetworkId = globalNetworkId,
        location = location,
        tags = tags,
    )
}
