@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SiteToSiteVpnAttachment].
 */
@PulumiTagMarker
public class SiteToSiteVpnAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SiteToSiteVpnAttachmentArgs = SiteToSiteVpnAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SiteToSiteVpnAttachmentArgsBuilder.() -> Unit) {
        val builder = SiteToSiteVpnAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SiteToSiteVpnAttachment {
        val builtJavaResource =
            com.pulumi.aws.networkmanager.SiteToSiteVpnAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SiteToSiteVpnAttachment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Manager SiteToSiteAttachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.SiteToSiteVpnAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpnConnectionArn: exampleAwsVpnConnection.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.SiteToSiteVpnAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpn_connection_arn=example_aws_vpn_connection["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.SiteToSiteVpnAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpnConnectionArn = exampleAwsVpnConnection.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewSiteToSiteVpnAttachment(ctx, "example", &networkmanager.SiteToSiteVpnAttachmentArgs{
 * 			CoreNetworkId:    pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * 			VpnConnectionArn: pulumi.Any(exampleAwsVpnConnection.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachment;
 * import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SiteToSiteVpnAttachment("example", SiteToSiteVpnAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpnConnectionArn(exampleAwsVpnConnection.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:SiteToSiteVpnAttachment
 *     properties:
 *       coreNetworkId: ${exampleAwsccNetworkmanagerCoreNetwork.id}
 *       vpnConnectionArn: ${exampleAwsVpnConnection.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_site_to_site_vpn_attachment` using the attachment ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/siteToSiteVpnAttachment:SiteToSiteVpnAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 */
public class SiteToSiteVpnAttachment internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.SiteToSiteVpnAttachment,
) : KotlinCustomResource(javaResource, SiteToSiteVpnAttachmentMapper) {
    /**
     * The ARN of the attachment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The policy rule number associated with the attachment.
     */
    public val attachmentPolicyRuleNumber: Output<Int>
        get() = javaResource.attachmentPolicyRuleNumber().applyValue({ args0 -> args0 })

    /**
     * The type of attachment.
     */
    public val attachmentType: Output<String>
        get() = javaResource.attachmentType().applyValue({ args0 -> args0 })

    /**
     * The ARN of a core network.
     */
    public val coreNetworkArn: Output<String>
        get() = javaResource.coreNetworkArn().applyValue({ args0 -> args0 })

    /**
     * The ID of a core network for the VPN attachment.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    /**
     * The Region where the edge is located.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * The ID of the attachment account owner.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The attachment resource ARN.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The name of the segment attachment.
     */
    public val segmentName: Output<String>
        get() = javaResource.segmentName().applyValue({ args0 -> args0 })

    /**
     * The state of the attachment.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ARN of the site-to-site VPN connection.
     * The following arguments are optional:
     */
    public val vpnConnectionArn: Output<String>
        get() = javaResource.vpnConnectionArn().applyValue({ args0 -> args0 })
}

public object SiteToSiteVpnAttachmentMapper : ResourceMapper<SiteToSiteVpnAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.SiteToSiteVpnAttachment::class == javaResource::class

    override fun map(javaResource: Resource): SiteToSiteVpnAttachment =
        SiteToSiteVpnAttachment(javaResource as com.pulumi.aws.networkmanager.SiteToSiteVpnAttachment)
}

/**
 * @see [SiteToSiteVpnAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SiteToSiteVpnAttachment].
 */
public suspend fun siteToSiteVpnAttachment(
    name: String,
    block: suspend SiteToSiteVpnAttachmentResourceBuilder.() -> Unit,
): SiteToSiteVpnAttachment {
    val builder = SiteToSiteVpnAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SiteToSiteVpnAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun siteToSiteVpnAttachment(name: String): SiteToSiteVpnAttachment {
    val builder = SiteToSiteVpnAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
