@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager SiteToSiteAttachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.SiteToSiteVpnAttachment("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpnConnectionArn: exampleAwsVpnConnection.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.SiteToSiteVpnAttachment("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpn_connection_arn=example_aws_vpn_connection["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.SiteToSiteVpnAttachment("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpnConnectionArn = exampleAwsVpnConnection.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewSiteToSiteVpnAttachment(ctx, "example", &networkmanager.SiteToSiteVpnAttachmentArgs{
 * 			CoreNetworkId:    pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * 			VpnConnectionArn: pulumi.Any(exampleAwsVpnConnection.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachment;
 * import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SiteToSiteVpnAttachment("example", SiteToSiteVpnAttachmentArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpnConnectionArn(exampleAwsVpnConnection.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:SiteToSiteVpnAttachment
 *     properties:
 *       coreNetworkId: ${exampleAwsccNetworkmanagerCoreNetwork.id}
 *       vpnConnectionArn: ${exampleAwsVpnConnection.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_site_to_site_vpn_attachment` using the attachment ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/siteToSiteVpnAttachment:SiteToSiteVpnAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property coreNetworkId The ID of a core network for the VPN attachment.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpnConnectionArn The ARN of the site-to-site VPN connection.
 * The following arguments are optional:
 */
public data class SiteToSiteVpnAttachmentArgs(
    public val coreNetworkId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpnConnectionArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs =
        com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpnConnectionArn(vpnConnectionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteToSiteVpnAttachmentArgs].
 */
@PulumiTagMarker
public class SiteToSiteVpnAttachmentArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpnConnectionArn: Output<String>? = null

    /**
     * @param value The ID of a core network for the VPN attachment.
     */
    @JvmName("urwcplnuyqhxndve")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hignpcbyfkdnivyr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the site-to-site VPN connection.
     * The following arguments are optional:
     */
    @JvmName("auckigcnhqfeqcsc")
    public suspend fun vpnConnectionArn(`value`: Output<String>) {
        this.vpnConnectionArn = value
    }

    /**
     * @param value The ID of a core network for the VPN attachment.
     */
    @JvmName("nycqhcsmqlicffaj")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wkicytvqqqrptqts")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mmhylcnwrfhtrpcr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the site-to-site VPN connection.
     * The following arguments are optional:
     */
    @JvmName("tykdttogxddckanl")
    public suspend fun vpnConnectionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnConnectionArn = mapped
    }

    internal fun build(): SiteToSiteVpnAttachmentArgs = SiteToSiteVpnAttachmentArgs(
        coreNetworkId = coreNetworkId,
        tags = tags,
        vpnConnectionArn = vpnConnectionArn,
    )
}
