@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a transit gateway Connect peer with a device, and optionally, with a link.
 * If you specify a link, it must be associated with the specified device.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.TransitGatewayConnectPeerAssociation("example", {
 *     globalNetworkId: exampleAwsNetworkmanagerGlobalNetwork.id,
 *     deviceId: exampleAwsNetworkmanagerDevice.id,
 *     transitGatewayConnectPeerArn: exampleAwsEc2TransitGatewayConnectPeer.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.TransitGatewayConnectPeerAssociation("example",
 *     global_network_id=example_aws_networkmanager_global_network["id"],
 *     device_id=example_aws_networkmanager_device["id"],
 *     transit_gateway_connect_peer_arn=example_aws_ec2_transit_gateway_connect_peer["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.TransitGatewayConnectPeerAssociation("example", new()
 *     {
 *         GlobalNetworkId = exampleAwsNetworkmanagerGlobalNetwork.Id,
 *         DeviceId = exampleAwsNetworkmanagerDevice.Id,
 *         TransitGatewayConnectPeerArn = exampleAwsEc2TransitGatewayConnectPeer.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewTransitGatewayConnectPeerAssociation(ctx, "example", &networkmanager.TransitGatewayConnectPeerAssociationArgs{
 * 			GlobalNetworkId:              pulumi.Any(exampleAwsNetworkmanagerGlobalNetwork.Id),
 * 			DeviceId:                     pulumi.Any(exampleAwsNetworkmanagerDevice.Id),
 * 			TransitGatewayConnectPeerArn: pulumi.Any(exampleAwsEc2TransitGatewayConnectPeer.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociation;
 * import com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGatewayConnectPeerAssociation("example", TransitGatewayConnectPeerAssociationArgs.builder()
 *             .globalNetworkId(exampleAwsNetworkmanagerGlobalNetwork.id())
 *             .deviceId(exampleAwsNetworkmanagerDevice.id())
 *             .transitGatewayConnectPeerArn(exampleAwsEc2TransitGatewayConnectPeer.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:TransitGatewayConnectPeerAssociation
 *     properties:
 *       globalNetworkId: ${exampleAwsNetworkmanagerGlobalNetwork.id}
 *       deviceId: ${exampleAwsNetworkmanagerDevice.id}
 *       transitGatewayConnectPeerArn: ${exampleAwsEc2TransitGatewayConnectPeer.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_connect_peer_association` using the global network ID and customer gateway ARN. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/transitGatewayConnectPeerAssociation:TransitGatewayConnectPeerAssociation example global-network-0d47f6t230mz46dy4,arn:aws:ec2:us-west-2:123456789012:transit-gateway-connect-peer/tgw-connect-peer-12345678
 * ```
 * @property deviceId The ID of the device.
 * @property globalNetworkId The ID of the global network.
 * @property linkId The ID of the link.
 * @property transitGatewayConnectPeerArn The Amazon Resource Name (ARN) of the Connect peer.
 */
public data class TransitGatewayConnectPeerAssociationArgs(
    public val deviceId: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val linkId: Output<String>? = null,
    public val transitGatewayConnectPeerArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociationArgs =
        com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociationArgs.builder()
            .deviceId(deviceId?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .linkId(linkId?.applyValue({ args0 -> args0 }))
            .transitGatewayConnectPeerArn(transitGatewayConnectPeerArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitGatewayConnectPeerAssociationArgs].
 */
@PulumiTagMarker
public class TransitGatewayConnectPeerAssociationArgsBuilder internal constructor() {
    private var deviceId: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var linkId: Output<String>? = null

    private var transitGatewayConnectPeerArn: Output<String>? = null

    /**
     * @param value The ID of the device.
     */
    @JvmName("idxcrlhtxmqlnndh")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("biforsaufwcobkyj")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("kjumasfssoattoxe")
    public suspend fun linkId(`value`: Output<String>) {
        this.linkId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Connect peer.
     */
    @JvmName("liftbweyppacplvu")
    public suspend fun transitGatewayConnectPeerArn(`value`: Output<String>) {
        this.transitGatewayConnectPeerArn = value
    }

    /**
     * @param value The ID of the device.
     */
    @JvmName("vfukeprmiwmtlbce")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("xvubcdinoxjcdpbc")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("tscpkvntyrcmlrtu")
    public suspend fun linkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Connect peer.
     */
    @JvmName("vwqjvkielotirgry")
    public suspend fun transitGatewayConnectPeerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayConnectPeerArn = mapped
    }

    internal fun build(): TransitGatewayConnectPeerAssociationArgs =
        TransitGatewayConnectPeerAssociationArgs(
            deviceId = deviceId,
            globalNetworkId = globalNetworkId,
            linkId = linkId,
            transitGatewayConnectPeerArn = transitGatewayConnectPeerArn,
        )
}
