@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TransitGatewayPeering].
 */
@PulumiTagMarker
public class TransitGatewayPeeringResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitGatewayPeeringArgs = TransitGatewayPeeringArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitGatewayPeeringArgsBuilder.() -> Unit) {
        val builder = TransitGatewayPeeringArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitGatewayPeering {
        val builtJavaResource =
            com.pulumi.aws.networkmanager.TransitGatewayPeering(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitGatewayPeering(builtJavaResource)
    }
}

/**
 * Creates a peering connection between an AWS Cloud WAN core network and an AWS Transit Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.TransitGatewayPeering("example", {
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     transitGatewayArn: exampleAwsEc2TransitGateway.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.TransitGatewayPeering("example",
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     transit_gateway_arn=example_aws_ec2_transit_gateway["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.TransitGatewayPeering("example", new()
 *     {
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         TransitGatewayArn = exampleAwsEc2TransitGateway.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewTransitGatewayPeering(ctx, "example", &networkmanager.TransitGatewayPeeringArgs{
 * 			CoreNetworkId:     pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * 			TransitGatewayArn: pulumi.Any(exampleAwsEc2TransitGateway.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.TransitGatewayPeering;
 * import com.pulumi.aws.networkmanager.TransitGatewayPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGatewayPeering("example", TransitGatewayPeeringArgs.builder()
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .transitGatewayArn(exampleAwsEc2TransitGateway.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:TransitGatewayPeering
 *     properties:
 *       coreNetworkId: ${exampleAwsccNetworkmanagerCoreNetwork.id}
 *       transitGatewayArn: ${exampleAwsEc2TransitGateway.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_peering` using the peering ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/transitGatewayPeering:TransitGatewayPeering example peering-444555aaabbb11223
 * ```
 */
public class TransitGatewayPeering internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.TransitGatewayPeering,
) : KotlinCustomResource(javaResource, TransitGatewayPeeringMapper) {
    /**
     * Peering Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the core network.
     */
    public val coreNetworkArn: Output<String>
        get() = javaResource.coreNetworkArn().applyValue({ args0 -> args0 })

    /**
     * The ID of a core network.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    /**
     * The edge location for the peer.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * The ID of the account owner.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The type of peering. This will be `TRANSIT_GATEWAY`.
     */
    public val peeringType: Output<String>
        get() = javaResource.peeringType().applyValue({ args0 -> args0 })

    /**
     * The resource ARN of the peer.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ARN of the transit gateway for the peering request.
     */
    public val transitGatewayArn: Output<String>
        get() = javaResource.transitGatewayArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the transit gateway peering attachment.
     */
    public val transitGatewayPeeringAttachmentId: Output<String>
        get() = javaResource.transitGatewayPeeringAttachmentId().applyValue({ args0 -> args0 })
}

public object TransitGatewayPeeringMapper : ResourceMapper<TransitGatewayPeering> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.TransitGatewayPeering::class == javaResource::class

    override fun map(javaResource: Resource): TransitGatewayPeering =
        TransitGatewayPeering(javaResource as com.pulumi.aws.networkmanager.TransitGatewayPeering)
}

/**
 * @see [TransitGatewayPeering].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitGatewayPeering].
 */
public suspend fun transitGatewayPeering(
    name: String,
    block: suspend TransitGatewayPeeringResourceBuilder.() -> Unit,
): TransitGatewayPeering {
    val builder = TransitGatewayPeeringResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitGatewayPeering].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitGatewayPeering(name: String): TransitGatewayPeering {
    val builder = TransitGatewayPeeringResourceBuilder()
    builder.name(name)
    return builder.build()
}
