@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransitGatewayRegistration].
 */
@PulumiTagMarker
public class TransitGatewayRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitGatewayRegistrationArgs = TransitGatewayRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitGatewayRegistrationArgsBuilder.() -> Unit) {
        val builder = TransitGatewayRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitGatewayRegistration {
        val builtJavaResource =
            com.pulumi.aws.networkmanager.TransitGatewayRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitGatewayRegistration(builtJavaResource)
    }
}

/**
 * Registers a transit gateway to a global network. The transit gateway can be in any AWS Region,
 * but it must be owned by the same AWS account that owns the global network.
 * You cannot register a transit gateway in more than one global network.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.GlobalNetwork("example", {description: "example"});
 * const exampleTransitGateway = new aws.ec2transitgateway.TransitGateway("example", {});
 * const exampleTransitGatewayRegistration = new aws.networkmanager.TransitGatewayRegistration("example", {
 *     globalNetworkId: example.id,
 *     transitGatewayArn: exampleTransitGateway.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.GlobalNetwork("example", description="example")
 * example_transit_gateway = aws.ec2transitgateway.TransitGateway("example")
 * example_transit_gateway_registration = aws.networkmanager.TransitGatewayRegistration("example",
 *     global_network_id=example.id,
 *     transit_gateway_arn=example_transit_gateway.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.GlobalNetwork("example", new()
 *     {
 *         Description = "example",
 *     });
 *     var exampleTransitGateway = new Aws.Ec2TransitGateway.TransitGateway("example");
 *     var exampleTransitGatewayRegistration = new Aws.NetworkManager.TransitGatewayRegistration("example", new()
 *     {
 *         GlobalNetworkId = example.Id,
 *         TransitGatewayArn = exampleTransitGateway.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2transitgateway"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := networkmanager.NewGlobalNetwork(ctx, "example", &networkmanager.GlobalNetworkArgs{
 * 			Description: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitGateway, err := ec2transitgateway.NewTransitGateway(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = networkmanager.NewTransitGatewayRegistration(ctx, "example", &networkmanager.TransitGatewayRegistrationArgs{
 * 			GlobalNetworkId:   example.ID(),
 * 			TransitGatewayArn: exampleTransitGateway.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.GlobalNetworkArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistration;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalNetwork("example", GlobalNetworkArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway");
 *         var exampleTransitGatewayRegistration = new TransitGatewayRegistration("exampleTransitGatewayRegistration", TransitGatewayRegistrationArgs.builder()
 *             .globalNetworkId(example.id())
 *             .transitGatewayArn(exampleTransitGateway.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:GlobalNetwork
 *     properties:
 *       description: example
 *   exampleTransitGateway:
 *     type: aws:ec2transitgateway:TransitGateway
 *     name: example
 *   exampleTransitGatewayRegistration:
 *     type: aws:networkmanager:TransitGatewayRegistration
 *     name: example
 *     properties:
 *       globalNetworkId: ${example.id}
 *       transitGatewayArn: ${exampleTransitGateway.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_registration` using the global network ID and transit gateway ARN. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/transitGatewayRegistration:TransitGatewayRegistration example global-network-0d47f6t230mz46dy4,arn:aws:ec2:us-west-2:123456789012:transit-gateway/tgw-123abc05e04123abc
 * ```
 */
public class TransitGatewayRegistration internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.TransitGatewayRegistration,
) : KotlinCustomResource(javaResource, TransitGatewayRegistrationMapper) {
    /**
     * The ID of the Global Network to register to.
     */
    public val globalNetworkId: Output<String>
        get() = javaResource.globalNetworkId().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Transit Gateway to register.
     */
    public val transitGatewayArn: Output<String>
        get() = javaResource.transitGatewayArn().applyValue({ args0 -> args0 })
}

public object TransitGatewayRegistrationMapper : ResourceMapper<TransitGatewayRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.TransitGatewayRegistration::class == javaResource::class

    override fun map(javaResource: Resource): TransitGatewayRegistration =
        TransitGatewayRegistration(
            javaResource as
                com.pulumi.aws.networkmanager.TransitGatewayRegistration,
        )
}

/**
 * @see [TransitGatewayRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitGatewayRegistration].
 */
public suspend fun transitGatewayRegistration(
    name: String,
    block: suspend TransitGatewayRegistrationResourceBuilder.() -> Unit,
): TransitGatewayRegistration {
    val builder = TransitGatewayRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitGatewayRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitGatewayRegistration(name: String): TransitGatewayRegistration {
    val builder = TransitGatewayRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
