@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a transit gateway route table attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.TransitGatewayRouteTableAttachment("example", {
 *     peeringId: exampleAwsNetworkmanagerTransitGatewayPeering.id,
 *     transitGatewayRouteTableArn: exampleAwsEc2TransitGatewayRouteTable.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.TransitGatewayRouteTableAttachment("example",
 *     peering_id=example_aws_networkmanager_transit_gateway_peering["id"],
 *     transit_gateway_route_table_arn=example_aws_ec2_transit_gateway_route_table["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.TransitGatewayRouteTableAttachment("example", new()
 *     {
 *         PeeringId = exampleAwsNetworkmanagerTransitGatewayPeering.Id,
 *         TransitGatewayRouteTableArn = exampleAwsEc2TransitGatewayRouteTable.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewTransitGatewayRouteTableAttachment(ctx, "example", &networkmanager.TransitGatewayRouteTableAttachmentArgs{
 * 			PeeringId:                   pulumi.Any(exampleAwsNetworkmanagerTransitGatewayPeering.Id),
 * 			TransitGatewayRouteTableArn: pulumi.Any(exampleAwsEc2TransitGatewayRouteTable.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachment;
 * import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGatewayRouteTableAttachment("example", TransitGatewayRouteTableAttachmentArgs.builder()
 *             .peeringId(exampleAwsNetworkmanagerTransitGatewayPeering.id())
 *             .transitGatewayRouteTableArn(exampleAwsEc2TransitGatewayRouteTable.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:TransitGatewayRouteTableAttachment
 *     properties:
 *       peeringId: ${exampleAwsNetworkmanagerTransitGatewayPeering.id}
 *       transitGatewayRouteTableArn: ${exampleAwsEc2TransitGatewayRouteTable.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_route_table_attachment` using the attachment ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/transitGatewayRouteTableAttachment:TransitGatewayRouteTableAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property peeringId The ID of the peer for the attachment.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayRouteTableArn The ARN of the transit gateway route table for the attachment.
 */
public data class TransitGatewayRouteTableAttachmentArgs(
    public val peeringId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayRouteTableArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs =
        com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs.builder()
            .peeringId(peeringId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayRouteTableArn(transitGatewayRouteTableArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitGatewayRouteTableAttachmentArgs].
 */
@PulumiTagMarker
public class TransitGatewayRouteTableAttachmentArgsBuilder internal constructor() {
    private var peeringId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayRouteTableArn: Output<String>? = null

    /**
     * @param value The ID of the peer for the attachment.
     */
    @JvmName("enodguucvrpurjvx")
    public suspend fun peeringId(`value`: Output<String>) {
        this.peeringId = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hjkovprfusevihcn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the transit gateway route table for the attachment.
     */
    @JvmName("hrmxcdugnrkbchxy")
    public suspend fun transitGatewayRouteTableArn(`value`: Output<String>) {
        this.transitGatewayRouteTableArn = value
    }

    /**
     * @param value The ID of the peer for the attachment.
     */
    @JvmName("qsxrwuoqxugilhgu")
    public suspend fun peeringId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringId = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lovnxnhouqcrhkuh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("auvmxlxvlefrqljy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the transit gateway route table for the attachment.
     */
    @JvmName("kohcqpkmxjutdyrx")
    public suspend fun transitGatewayRouteTableArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayRouteTableArn = mapped
    }

    internal fun build(): TransitGatewayRouteTableAttachmentArgs =
        TransitGatewayRouteTableAttachmentArgs(
            peeringId = peeringId,
            tags = tags,
            transitGatewayRouteTableArn = transitGatewayRouteTableArn,
        )
}
