@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.VpcAttachmentOptions
import com.pulumi.aws.networkmanager.kotlin.outputs.VpcAttachmentOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcAttachment].
 */
@PulumiTagMarker
public class VpcAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcAttachmentArgs = VpcAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcAttachmentArgsBuilder.() -> Unit) {
        val builder = VpcAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcAttachment {
        val builtJavaResource = com.pulumi.aws.networkmanager.VpcAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcAttachment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Manager VPC Attachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: [exampleAwsSubnet&#46;arn],
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[example_aws_subnet["arn"]],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = new[]
 *         {
 *             exampleAwsSubnet.Arn,
 *         },
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * 			SubnetArns: pulumi.StringArray{
 * 				exampleAwsSubnet.Arn,
 * 			},
 * 			CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * 			VpcArn:        pulumi.Any(exampleAwsVpc.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.arn())
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:VpcAttachment
 *     properties:
 *       subnetArns:
 *         - ${exampleAwsSubnet.arn}
 *       coreNetworkId: ${exampleAwsccNetworkmanagerCoreNetwork.id}
 *       vpcArn: ${exampleAwsVpc.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_vpc_attachment` using the attachment ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/vpcAttachment:VpcAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 */
public class VpcAttachment internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.VpcAttachment,
) : KotlinCustomResource(javaResource, VpcAttachmentMapper) {
    /**
     * The ARN of the attachment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The policy rule number associated with the attachment.
     */
    public val attachmentPolicyRuleNumber: Output<Int>
        get() = javaResource.attachmentPolicyRuleNumber().applyValue({ args0 -> args0 })

    /**
     * The type of attachment.
     */
    public val attachmentType: Output<String>
        get() = javaResource.attachmentType().applyValue({ args0 -> args0 })

    /**
     * The ARN of a core network.
     */
    public val coreNetworkArn: Output<String>
        get() = javaResource.coreNetworkArn().applyValue({ args0 -> args0 })

    /**
     * The ID of a core network for the VPC attachment.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    /**
     * The Region where the edge is located.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * Options for the VPC attachment.
     */
    public val options: Output<VpcAttachmentOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the attachment account owner.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The attachment resource ARN.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The name of the segment attachment.
     */
    public val segmentName: Output<String>
        get() = javaResource.segmentName().applyValue({ args0 -> args0 })

    /**
     * The state of the attachment.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The subnet ARN of the VPC attachment.
     */
    public val subnetArns: Output<List<String>>
        get() = javaResource.subnetArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ARN of the VPC.
     * The following arguments are optional:
     */
    public val vpcArn: Output<String>
        get() = javaResource.vpcArn().applyValue({ args0 -> args0 })
}

public object VpcAttachmentMapper : ResourceMapper<VpcAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.VpcAttachment::class == javaResource::class

    override fun map(javaResource: Resource): VpcAttachment = VpcAttachment(
        javaResource as
            com.pulumi.aws.networkmanager.VpcAttachment,
    )
}

/**
 * @see [VpcAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcAttachment].
 */
public suspend fun vpcAttachment(
    name: String,
    block: suspend VpcAttachmentResourceBuilder.() -> Unit,
): VpcAttachment {
    val builder = VpcAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcAttachment(name: String): VpcAttachment {
    val builder = VpcAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
