@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.VpcAttachmentArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.VpcAttachmentOptionsArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.VpcAttachmentOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager VPC Attachment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.networkmanager.VpcAttachment("example", {
 *     subnetArns: [exampleAwsSubnet&#46;arn],
 *     coreNetworkId: exampleAwsccNetworkmanagerCoreNetwork.id,
 *     vpcArn: exampleAwsVpc.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.networkmanager.VpcAttachment("example",
 *     subnet_arns=[example_aws_subnet["arn"]],
 *     core_network_id=example_awscc_networkmanager_core_network["id"],
 *     vpc_arn=example_aws_vpc["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.NetworkManager.VpcAttachment("example", new()
 *     {
 *         SubnetArns = new[]
 *         {
 *             exampleAwsSubnet.Arn,
 *         },
 *         CoreNetworkId = exampleAwsccNetworkmanagerCoreNetwork.Id,
 *         VpcArn = exampleAwsVpc.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/networkmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkmanager.NewVpcAttachment(ctx, "example", &networkmanager.VpcAttachmentArgs{
 * 			SubnetArns: pulumi.StringArray{
 * 				exampleAwsSubnet.Arn,
 * 			},
 * 			CoreNetworkId: pulumi.Any(exampleAwsccNetworkmanagerCoreNetwork.Id),
 * 			VpcArn:        pulumi.Any(exampleAwsVpc.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(exampleAwsSubnet.arn())
 *             .coreNetworkId(exampleAwsccNetworkmanagerCoreNetwork.id())
 *             .vpcArn(exampleAwsVpc.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:networkmanager:VpcAttachment
 *     properties:
 *       subnetArns:
 *         - ${exampleAwsSubnet.arn}
 *       coreNetworkId: ${exampleAwsccNetworkmanagerCoreNetwork.id}
 *       vpcArn: ${exampleAwsVpc.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_vpc_attachment` using the attachment ID. For example:
 * ```sh
 * $ pulumi import aws:networkmanager/vpcAttachment:VpcAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property coreNetworkId The ID of a core network for the VPC attachment.
 * @property options Options for the VPC attachment.
 * @property subnetArns The subnet ARN of the VPC attachment.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcArn The ARN of the VPC.
 * The following arguments are optional:
 */
public data class VpcAttachmentArgs(
    public val coreNetworkId: Output<String>? = null,
    public val options: Output<VpcAttachmentOptionsArgs>? = null,
    public val subnetArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.VpcAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.VpcAttachmentArgs =
        com.pulumi.aws.networkmanager.VpcAttachmentArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetArns(subnetArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcArn(vpcArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcAttachmentArgs].
 */
@PulumiTagMarker
public class VpcAttachmentArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var options: Output<VpcAttachmentOptionsArgs>? = null

    private var subnetArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcArn: Output<String>? = null

    /**
     * @param value The ID of a core network for the VPC attachment.
     */
    @JvmName("pranokiuhpjeonii")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value Options for the VPC attachment.
     */
    @JvmName("nwyewinckniiwusc")
    public suspend fun options(`value`: Output<VpcAttachmentOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The subnet ARN of the VPC attachment.
     */
    @JvmName("pcdfvpnalivtjxvh")
    public suspend fun subnetArns(`value`: Output<List<String>>) {
        this.subnetArns = value
    }

    @JvmName("qqasvreuncyftxen")
    public suspend fun subnetArns(vararg values: Output<String>) {
        this.subnetArns = Output.all(values.asList())
    }

    /**
     * @param values The subnet ARN of the VPC attachment.
     */
    @JvmName("ulgfslicanyadsis")
    public suspend fun subnetArns(values: List<Output<String>>) {
        this.subnetArns = Output.all(values)
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ibjhaagsxydchhat")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the VPC.
     * The following arguments are optional:
     */
    @JvmName("gfuwbfardlpuocgi")
    public suspend fun vpcArn(`value`: Output<String>) {
        this.vpcArn = value
    }

    /**
     * @param value The ID of a core network for the VPC attachment.
     */
    @JvmName("rskudgttsgrwtcso")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value Options for the VPC attachment.
     */
    @JvmName("tevbtpfbashptdiw")
    public suspend fun options(`value`: VpcAttachmentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument Options for the VPC attachment.
     */
    @JvmName("asaotlobralxpvre")
    public suspend fun options(argument: suspend VpcAttachmentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VpcAttachmentOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The subnet ARN of the VPC attachment.
     */
    @JvmName("gjnmileiqdsduspp")
    public suspend fun subnetArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetArns = mapped
    }

    /**
     * @param values The subnet ARN of the VPC attachment.
     */
    @JvmName("xfmlkmbocoivgkcb")
    public suspend fun subnetArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetArns = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gspfcrthcvwmwoqj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kfxxuroioaashbno")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the VPC.
     * The following arguments are optional:
     */
    @JvmName("remaucubwpwvieav")
    public suspend fun vpcArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcArn = mapped
    }

    internal fun build(): VpcAttachmentArgs = VpcAttachmentArgs(
        coreNetworkId = coreNetworkId,
        options = options,
        subnetArns = subnetArns,
        tags = tags,
        vpcArn = vpcArn,
    )
}
