@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property protocol The protocol used for the attachment connection. Possible values are `GRE` and `NO_ENCAP`.
 */
public data class ConnectAttachmentOptionsArgs(
    public val protocol: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs =
        com.pulumi.aws.networkmanager.inputs.ConnectAttachmentOptionsArgs.builder()
            .protocol(protocol?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectAttachmentOptionsArgs].
 */
@PulumiTagMarker
public class ConnectAttachmentOptionsArgsBuilder internal constructor() {
    private var protocol: Output<String>? = null

    /**
     * @param value The protocol used for the attachment connection. Possible values are `GRE` and `NO_ENCAP`.
     */
    @JvmName("ssfhiyulrnvomruu")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value The protocol used for the attachment connection. Possible values are `GRE` and `NO_ENCAP`.
     */
    @JvmName("qqutpjcprbarnslw")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): ConnectAttachmentOptionsArgs = ConnectAttachmentOptionsArgs(
        protocol = protocol,
    )
}
