@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.DeviceAwsLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property subnetArn The Amazon Resource Name (ARN) of the subnet that the device is located in.
 * @property zone The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
 */
public data class DeviceAwsLocationArgs(
    public val subnetArn: Output<String>? = null,
    public val zone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.DeviceAwsLocationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.DeviceAwsLocationArgs =
        com.pulumi.aws.networkmanager.inputs.DeviceAwsLocationArgs.builder()
            .subnetArn(subnetArn?.applyValue({ args0 -> args0 }))
            .zone(zone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceAwsLocationArgs].
 */
@PulumiTagMarker
public class DeviceAwsLocationArgsBuilder internal constructor() {
    private var subnetArn: Output<String>? = null

    private var zone: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the subnet that the device is located in.
     */
    @JvmName("roslyddxfomtfauk")
    public suspend fun subnetArn(`value`: Output<String>) {
        this.subnetArn = value
    }

    /**
     * @param value The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
     */
    @JvmName("weoqciewgmiqhard")
    public suspend fun zone(`value`: Output<String>) {
        this.zone = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the subnet that the device is located in.
     */
    @JvmName("baimhmcqwkfeettq")
    public suspend fun subnetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetArn = mapped
    }

    /**
     * @param value The Zone that the device is located in. Specify the ID of an Availability Zone, Local Zone, Wavelength Zone, or an Outpost.
     */
    @JvmName("sejoggdklhdfbaad")
    public suspend fun zone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zone = mapped
    }

    internal fun build(): DeviceAwsLocationArgs = DeviceAwsLocationArgs(
        subnetArn = subnetArn,
        zone = zone,
    )
}
