@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.DeviceLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address The physical address.
 * @property latitude The latitude.
 * @property longitude The longitude.
 */
public data class DeviceLocationArgs(
    public val address: Output<String>? = null,
    public val latitude: Output<String>? = null,
    public val longitude: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.DeviceLocationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.DeviceLocationArgs =
        com.pulumi.aws.networkmanager.inputs.DeviceLocationArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .latitude(latitude?.applyValue({ args0 -> args0 }))
            .longitude(longitude?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceLocationArgs].
 */
@PulumiTagMarker
public class DeviceLocationArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var latitude: Output<String>? = null

    private var longitude: Output<String>? = null

    /**
     * @param value The physical address.
     */
    @JvmName("qmdwqjltdmdwimfl")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The latitude.
     */
    @JvmName("yulrtgkxxpxswxor")
    public suspend fun latitude(`value`: Output<String>) {
        this.latitude = value
    }

    /**
     * @param value The longitude.
     */
    @JvmName("xbxlshupdlsceirg")
    public suspend fun longitude(`value`: Output<String>) {
        this.longitude = value
    }

    /**
     * @param value The physical address.
     */
    @JvmName("ujhbeplrnkcmdedi")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The latitude.
     */
    @JvmName("fnipfxsnwdvcqhmx")
    public suspend fun latitude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latitude = mapped
    }

    /**
     * @param value The longitude.
     */
    @JvmName("tytjxvnpyondtcoi")
    public suspend fun longitude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.longitude = mapped
    }

    internal fun build(): DeviceLocationArgs = DeviceLocationArgs(
        address = address,
        latitude = latitude,
        longitude = longitude,
    )
}
