@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnection.
 * @property connectionId ID of the specific connection to retrieve.
 * @property globalNetworkId ID of the Global Network of the connection to retrieve.
 * @property tags Key-value tags for the connection.
 */
public data class GetConnectionPlainArgs(
    public val connectionId: String,
    public val globalNetworkId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetConnectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetConnectionPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetConnectionPlainArgs.builder()
            .connectionId(connectionId.let({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionPlainArgsBuilder internal constructor() {
    private var connectionId: String? = null

    private var globalNetworkId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the specific connection to retrieve.
     */
    @JvmName("kjojqyofekxumemj")
    public suspend fun connectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionId = mapped
    }

    /**
     * @param value ID of the Global Network of the connection to retrieve.
     */
    @JvmName("gqrdkmgvbrxildrw")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value Key-value tags for the connection.
     */
    @JvmName("hkpwmagftutyplgh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the connection.
     */
    @JvmName("nxbfdtyxxrpywcgs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetConnectionPlainArgs = GetConnectionPlainArgs(
        connectionId = connectionId ?: throw PulumiNullFieldException("connectionId"),
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        tags = tags,
    )
}
