@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnections.
 * @property deviceId ID of the device of the connections to retrieve.
 * @property globalNetworkId ID of the Global Network of the connections to retrieve.
 * @property tags Restricts the list to the connections with these tags.
 */
public data class GetConnectionsPlainArgs(
    public val deviceId: String? = null,
    public val globalNetworkId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetConnectionsPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetConnectionsPlainArgs.builder()
            .deviceId(deviceId?.let({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionsPlainArgsBuilder internal constructor() {
    private var deviceId: String? = null

    private var globalNetworkId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the device of the connections to retrieve.
     */
    @JvmName("jufvjrrsiklsxory")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deviceId = mapped
    }

    /**
     * @param value ID of the Global Network of the connections to retrieve.
     */
    @JvmName("ckhknxdejgbkkqny")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value Restricts the list to the connections with these tags.
     */
    @JvmName("ccsnuwrmgqbgotln")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Restricts the list to the connections with these tags.
     */
    @JvmName("ywjdcunqrlfnxjjb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetConnectionsPlainArgs = GetConnectionsPlainArgs(
        deviceId = deviceId,
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        tags = tags,
    )
}
