@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicy.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take when a condition is true. Detailed Below.
 * @property conditionLogic Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
 * @property conditions A block argument. Detailed Below.
 * @property description A user-defined description that further helps identify the rule.
 * @property ruleNumber An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
 */
public data class GetCoreNetworkPolicyDocumentAttachmentPolicy(
    public val action: GetCoreNetworkPolicyDocumentAttachmentPolicyAction,
    public val conditionLogic: String? = null,
    public val conditions: List<GetCoreNetworkPolicyDocumentAttachmentPolicyCondition>,
    public val description: String? = null,
    public val ruleNumber: Int,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicy> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicy =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicy.builder()
            .action(action.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .conditionLogic(conditionLogic?.let({ args0 -> args0 }))
            .conditions(conditions.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .description(description?.let({ args0 -> args0 }))
            .ruleNumber(ruleNumber.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentAttachmentPolicy].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentAttachmentPolicyBuilder internal constructor() {
    private var action: GetCoreNetworkPolicyDocumentAttachmentPolicyAction? = null

    private var conditionLogic: String? = null

    private var conditions: List<GetCoreNetworkPolicyDocumentAttachmentPolicyCondition>? = null

    private var description: String? = null

    private var ruleNumber: Int? = null

    /**
     * @param value Action to take when a condition is true. Detailed Below.
     */
    @JvmName("rdmtetxwaywjyiis")
    public suspend fun action(`value`: GetCoreNetworkPolicyDocumentAttachmentPolicyAction) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.action = mapped
    }

    /**
     * @param argument Action to take when a condition is true. Detailed Below.
     */
    @JvmName("rjjukmtuiavyoejp")
    public suspend fun action(argument: suspend GetCoreNetworkPolicyDocumentAttachmentPolicyActionBuilder.() -> Unit) {
        val toBeMapped = GetCoreNetworkPolicyDocumentAttachmentPolicyActionBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.action = mapped
    }

    /**
     * @param value Valid values include `and` or `or`. This is a mandatory parameter only if you have more than one condition. The `condition_logic` apply to all of the conditions for a rule, which also means nested conditions of `and` or `or` are not supported. Use `or` if you want to associate the attachment with the segment by either the segment name or attachment tag value, or by the chosen conditions. Use `and` if you want to associate the attachment with the segment by either the segment name or attachment tag value and by the chosen conditions. Detailed Below.
     */
    @JvmName("jqxmhqjeyqmwcfut")
    public suspend fun conditionLogic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.conditionLogic = mapped
    }

    /**
     * @param value A block argument. Detailed Below.
     */
    @JvmName("ulbiwtlhcavkqrkd")
    public suspend fun conditions(`value`: List<GetCoreNetworkPolicyDocumentAttachmentPolicyCondition>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.conditions = mapped
    }

    /**
     * @param argument A block argument. Detailed Below.
     */
    @JvmName("amxysuwbkcltwmfc")
    public suspend fun conditions(argument: List<suspend GetCoreNetworkPolicyDocumentAttachmentPolicyConditionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentAttachmentPolicyConditionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param argument A block argument. Detailed Below.
     */
    @JvmName("ulfuctlgalowxjyi")
    public suspend fun conditions(vararg argument: suspend GetCoreNetworkPolicyDocumentAttachmentPolicyConditionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentAttachmentPolicyConditionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param argument A block argument. Detailed Below.
     */
    @JvmName("lrtvhyucefukdesq")
    public suspend fun conditions(argument: suspend GetCoreNetworkPolicyDocumentAttachmentPolicyConditionBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetCoreNetworkPolicyDocumentAttachmentPolicyConditionBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.conditions = mapped
    }

    /**
     * @param values A block argument. Detailed Below.
     */
    @JvmName("iewuswlrrnugcyjy")
    public suspend fun conditions(vararg values: GetCoreNetworkPolicyDocumentAttachmentPolicyCondition) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.conditions = mapped
    }

    /**
     * @param value A user-defined description that further helps identify the rule.
     */
    @JvmName("rsrmfkacenmxfjjo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value An integer from `1` to `65535` indicating the rule's order number. Rules are processed in order from the lowest numbered rule to the highest. Rules stop processing when a rule is matched. It's important to make sure that you number your rules in the exact order that you want them processed.
     */
    @JvmName("xwnoulkmbvfhfflu")
    public suspend fun ruleNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleNumber = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentAttachmentPolicy =
        GetCoreNetworkPolicyDocumentAttachmentPolicy(
            action = action ?: throw PulumiNullFieldException("action"),
            conditionLogic = conditionLogic,
            conditions = conditions ?: throw PulumiNullFieldException("conditions"),
            description = description,
            ruleNumber = ruleNumber ?: throw PulumiNullFieldException("ruleNumber"),
        )
}
