@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyAction.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addToNetworkFunctionGroup The name of the network function group to attach to the attachment policy.
 * @property associationMethod Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
 * @property requireAcceptance Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
 * @property segment Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
 * @property tagValueOfKey Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
 */
public data class GetCoreNetworkPolicyDocumentAttachmentPolicyAction(
    public val addToNetworkFunctionGroup: String? = null,
    public val associationMethod: String? = null,
    public val requireAcceptance: Boolean? = null,
    public val segment: String? = null,
    public val tagValueOfKey: String? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyAction> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyAction =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyAction.builder()
            .addToNetworkFunctionGroup(addToNetworkFunctionGroup?.let({ args0 -> args0 }))
            .associationMethod(associationMethod?.let({ args0 -> args0 }))
            .requireAcceptance(requireAcceptance?.let({ args0 -> args0 }))
            .segment(segment?.let({ args0 -> args0 }))
            .tagValueOfKey(tagValueOfKey?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentAttachmentPolicyAction].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentAttachmentPolicyActionBuilder internal constructor() {
    private var addToNetworkFunctionGroup: String? = null

    private var associationMethod: String? = null

    private var requireAcceptance: Boolean? = null

    private var segment: String? = null

    private var tagValueOfKey: String? = null

    /**
     * @param value The name of the network function group to attach to the attachment policy.
     */
    @JvmName("hmposoijuclskeua")
    public suspend fun addToNetworkFunctionGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.addToNetworkFunctionGroup = mapped
    }

    /**
     * @param value Defines how a segment is mapped. Values can be `constant` or `tag`. `constant` statically defines the segment to associate the attachment to. `tag` uses the value of a tag to dynamically try to map to a segment.reference_policies_elements_condition_operators.html) to evaluate.
     */
    @JvmName("xnkrpmpvkjkyamup")
    public suspend fun associationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.associationMethod = mapped
    }

    /**
     * @param value Determines if this mapping should override the segment value for `require_attachment_acceptance`. You can only set this to `true`, indicating that this setting applies only to segments that have `require_attachment_acceptance` set to `false`. If the segment already has the default `require_attachment_acceptance`, you can set this to inherit segment’s acceptance value.
     */
    @JvmName("jflkfeytbggpixdr")
    public suspend fun requireAcceptance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.requireAcceptance = mapped
    }

    /**
     * @param value Name of the `segment` to share as defined in the `segments` section. This is used only when the `association_method` is `constant`.
     */
    @JvmName("lbgoavnnthiebvow")
    public suspend fun segment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.segment = mapped
    }

    /**
     * @param value Maps the attachment to the value of a known key. This is used with the `association_method` is `tag`. For example a `tag` of `stage = “test”`, will map to a segment named `test`. The value must exactly match the name of a segment. This allows you to have many segments, but use only a single rule without having to define multiple nearly identical conditions. This prevents creating many similar conditions that all use the same keys to map to segments.
     */
    @JvmName("qwrwqgvyqrfytyya")
    public suspend fun tagValueOfKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tagValueOfKey = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentAttachmentPolicyAction =
        GetCoreNetworkPolicyDocumentAttachmentPolicyAction(
            addToNetworkFunctionGroup = addToNetworkFunctionGroup,
            associationMethod = associationMethod,
            requireAcceptance = requireAcceptance,
            segment = segment,
            tagValueOfKey = tagValueOfKey,
        )
}
