@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyCondition.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key string value
 * @property operator Valid values include: `equals`, `not-equals`, `contains`, `begins-with`.
 * @property type Valid values include: `account-id`, `any`, `tag-value`, `tag-exists`, `resource-id`, `region`, `attachment-type`.
 * @property value string value
 */
public data class GetCoreNetworkPolicyDocumentAttachmentPolicyCondition(
    public val key: String? = null,
    public val `operator`: String? = null,
    public val type: String,
    public val `value`: String? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyCondition> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyCondition =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicyCondition.builder()
            .key(key?.let({ args0 -> args0 }))
            .`operator`(`operator`?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 }))
            .`value`(`value`?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentAttachmentPolicyCondition].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentAttachmentPolicyConditionBuilder internal constructor() {
    private var key: String? = null

    private var `operator`: String? = null

    private var type: String? = null

    private var `value`: String? = null

    /**
     * @param value string value
     */
    @JvmName("cwjgllexcfjrpwcm")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value Valid values include: `equals`, `not-equals`, `contains`, `begins-with`.
     */
    @JvmName("nlpenuwpnpeyoayy")
    public suspend fun `operator`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`operator` = mapped
    }

    /**
     * @param value Valid values include: `account-id`, `any`, `tag-value`, `tag-exists`, `resource-id`, `region`, `attachment-type`.
     */
    @JvmName("xjblbvmbxsthynix")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value string value
     */
    @JvmName("svffysavonrohwsg")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`value` = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentAttachmentPolicyCondition =
        GetCoreNetworkPolicyDocumentAttachmentPolicyCondition(
            key = key,
            `operator` = `operator`,
            type = type ?: throw PulumiNullFieldException("type"),
            `value` = `value`,
        )
}
