@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property asnRanges List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
 * @property edgeLocations A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
 * @property insideCidrBlocks The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
 * @property vpnEcmpSupport Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
 */
public data class GetCoreNetworkPolicyDocumentCoreNetworkConfiguration(
    public val asnRanges: List<String>,
    public val edgeLocations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation>,
    public val insideCidrBlocks: List<String>? = null,
    public val vpnEcmpSupport: Boolean? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration.builder()
            .asnRanges(asnRanges.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .edgeLocations(
                edgeLocations.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .insideCidrBlocks(insideCidrBlocks?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpnEcmpSupport(vpnEcmpSupport?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentCoreNetworkConfiguration].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationBuilder internal constructor() {
    private var asnRanges: List<String>? = null

    private var edgeLocations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation>? =
        null

    private var insideCidrBlocks: List<String>? = null

    private var vpnEcmpSupport: Boolean? = null

    /**
     * @param value List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
     */
    @JvmName("xqbpabfrqxxyqkjk")
    public suspend fun asnRanges(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.asnRanges = mapped
    }

    /**
     * @param values List of strings containing Autonomous System Numbers (ASNs) to assign to Core Network Edges. By default, the core network automatically assigns an ASN for each Core Network Edge but you can optionally define the ASN in the edge-locations for each Region. The ASN uses an array of integer ranges only from `64512` to `65534` and `4200000000` to `4294967294` expressed as a string like `"64512-65534"`. No other ASN ranges can be used.
     */
    @JvmName("hmrevhnccsewydwh")
    public suspend fun asnRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.asnRanges = mapped
    }

    /**
     * @param value A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
     */
    @JvmName("rmxswypdfixsngqt")
    public suspend fun edgeLocations(`value`: List<GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeLocations = mapped
    }

    /**
     * @param argument A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
     */
    @JvmName("uaoaqneyskjubkmx")
    public suspend fun edgeLocations(argument: List<suspend GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.edgeLocations = mapped
    }

    /**
     * @param argument A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
     */
    @JvmName("lfqqemffgcfvdwgm")
    public suspend fun edgeLocations(vararg argument: suspend GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.edgeLocations = mapped
    }

    /**
     * @param argument A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
     */
    @JvmName("boisjxoxxstcevfq")
    public suspend fun edgeLocations(argument: suspend GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = toBeMapped
        this.edgeLocations = mapped
    }

    /**
     * @param values A block value of AWS Region locations where you're creating Core Network Edges. Detailed below.
     */
    @JvmName("vkdkiyyfgvqlyppl")
    public suspend fun edgeLocations(vararg values: GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeLocations = mapped
    }

    /**
     * @param value The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
     */
    @JvmName("lfnsaportvqvoiim")
    public suspend fun insideCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param values The Classless Inter-Domain Routing (CIDR) block range used to create tunnels for AWS Transit Gateway Connect. The format is standard AWS CIDR range (for example, `10.0.1.0/24`). You can optionally define the inside CIDR in the Core Network Edges section per Region. The minimum is a `/24` for IPv4 or `/64` for IPv6. You can provide multiple `/24` subnets or a larger CIDR range. If you define a larger CIDR range, new Core Network Edges will be automatically assigned `/24` and `/64` subnets from the larger CIDR. an Inside CIDR block is required for attaching Connect attachments to a Core Network Edge.
     */
    @JvmName("deojbxuqgtfcughm")
    public suspend fun insideCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param value Indicates whether the core network forwards traffic over multiple equal-cost routes using VPN. The value can be either `true` or `false`. The default is `true`.
     */
    @JvmName("xmycnfknycmmscea")
    public suspend fun vpnEcmpSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpnEcmpSupport = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentCoreNetworkConfiguration =
        GetCoreNetworkPolicyDocumentCoreNetworkConfiguration(
            asnRanges = asnRanges ?: throw PulumiNullFieldException("asnRanges"),
            edgeLocations = edgeLocations ?: throw PulumiNullFieldException("edgeLocations"),
            insideCidrBlocks = insideCidrBlocks,
            vpnEcmpSupport = vpnEcmpSupport,
        )
}
