@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property asn ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
 * @property insideCidrBlocks The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
 * @property location
 */
public data class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation(
    public val asn: String? = null,
    public val insideCidrBlocks: List<String>? = null,
    public val location: String,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation.builder()
            .asn(asn?.let({ args0 -> args0 }))
            .insideCidrBlocks(insideCidrBlocks?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationBuilder internal constructor() {
    private var asn: String? = null

    private var insideCidrBlocks: List<String>? = null

    private var location: String? = null

    /**
     * @param value ASN of the Core Network Edge in an AWS Region. By default, the ASN will be a single integer automatically assigned from `asn_ranges`
     */
    @JvmName("ayusbphqrlqknubu")
    public suspend fun asn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.asn = mapped
    }

    /**
     * @param value The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
     */
    @JvmName("ltwtwwkbolirshyf")
    public suspend fun insideCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param values The local CIDR blocks for this Core Network Edge for AWS Transit Gateway Connect attachments. By default, this CIDR block will be one or more optional IPv4 and IPv6 CIDR prefixes auto-assigned from `inside_cidr_blocks`.
     */
    @JvmName("srmmaepfgpcmneln")
    public suspend fun insideCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param value
     */
    @JvmName("guhdjasbbtqyjguy")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation =
        GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocation(
            asn = asn,
            insideCidrBlocks = insideCidrBlocks,
            location = location ?: throw PulumiNullFieldException("location"),
        )
}
