@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentNetworkFunctionGroup.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Optional description of the network function group.
 * @property name This identifies the network function group container.
 * @property requireAttachmentAcceptance This will be either `true`, that attachment acceptance is required, or `false`, that it is not required.
 */
public data class GetCoreNetworkPolicyDocumentNetworkFunctionGroup(
    public val description: String? = null,
    public val name: String,
    public val requireAttachmentAcceptance: Boolean,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentNetworkFunctionGroup> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentNetworkFunctionGroup =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentNetworkFunctionGroup.builder()
            .description(description?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .requireAttachmentAcceptance(requireAttachmentAcceptance.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentNetworkFunctionGroup].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentNetworkFunctionGroupBuilder internal constructor() {
    private var description: String? = null

    private var name: String? = null

    private var requireAttachmentAcceptance: Boolean? = null

    /**
     * @param value Optional description of the network function group.
     */
    @JvmName("snurbjpjblkhifqu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value This identifies the network function group container.
     */
    @JvmName("taanhihqkrkgctir")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value This will be either `true`, that attachment acceptance is required, or `false`, that it is not required.
     */
    @JvmName("hcurepdnqstuimdk")
    public suspend fun requireAttachmentAcceptance(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.requireAttachmentAcceptance = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentNetworkFunctionGroup =
        GetCoreNetworkPolicyDocumentNetworkFunctionGroup(
            description = description,
            name = name ?: throw PulumiNullFieldException("name"),
            requireAttachmentAcceptance = requireAttachmentAcceptance ?: throw
                PulumiNullFieldException("requireAttachmentAcceptance"),
        )
}
