@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCoreNetworkPolicyDocument.
 * @property attachmentPolicies In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
 * @property coreNetworkConfigurations The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
 * @property networkFunctionGroups Block argument that defines the service insertion actions you want to include. Detailed below.
 * @property segmentActions A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
 * @property segments Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
 * @property version
 */
public data class GetCoreNetworkPolicyDocumentPlainArgs(
    public val attachmentPolicies: List<GetCoreNetworkPolicyDocumentAttachmentPolicy>? = null,
    public val coreNetworkConfigurations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfiguration>,
    public val networkFunctionGroups: List<GetCoreNetworkPolicyDocumentNetworkFunctionGroup>? = null,
    public val segmentActions: List<GetCoreNetworkPolicyDocumentSegmentAction>? = null,
    public val segments: List<GetCoreNetworkPolicyDocumentSegment>,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentPlainArgs = com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentPlainArgs.builder()
        .attachmentPolicies(
            attachmentPolicies?.let({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .coreNetworkConfigurations(
            coreNetworkConfigurations.let({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .networkFunctionGroups(
            networkFunctionGroups?.let({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .segmentActions(
            segmentActions?.let({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .segments(segments.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentPlainArgs].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentPlainArgsBuilder internal constructor() {
    private var attachmentPolicies: List<GetCoreNetworkPolicyDocumentAttachmentPolicy>? = null

    private var coreNetworkConfigurations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfiguration>? =
        null

    private var networkFunctionGroups: List<GetCoreNetworkPolicyDocumentNetworkFunctionGroup>? = null

    private var segmentActions: List<GetCoreNetworkPolicyDocumentSegmentAction>? = null

    private var segments: List<GetCoreNetworkPolicyDocumentSegment>? = null

    private var version: String? = null

    /**
     * @param value In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
     */
    @JvmName("htilikglrwsbsimn")
    public suspend fun attachmentPolicies(`value`: List<GetCoreNetworkPolicyDocumentAttachmentPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.attachmentPolicies = mapped
    }

    /**
     * @param argument In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
     */
    @JvmName("sboqqarlxmeqetbd")
    public suspend fun attachmentPolicies(argument: List<suspend GetCoreNetworkPolicyDocumentAttachmentPolicyBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentAttachmentPolicyBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.attachmentPolicies = mapped
    }

    /**
     * @param argument In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
     */
    @JvmName("gnrummhegwetbtmo")
    public suspend fun attachmentPolicies(vararg argument: suspend GetCoreNetworkPolicyDocumentAttachmentPolicyBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentAttachmentPolicyBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.attachmentPolicies = mapped
    }

    /**
     * @param argument In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
     */
    @JvmName("fbgdacxiiycmjafj")
    public suspend fun attachmentPolicies(argument: suspend GetCoreNetworkPolicyDocumentAttachmentPolicyBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetCoreNetworkPolicyDocumentAttachmentPolicyBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.attachmentPolicies = mapped
    }

    /**
     * @param values In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
     */
    @JvmName("ssmppwixvvxnbbpb")
    public suspend fun attachmentPolicies(vararg values: GetCoreNetworkPolicyDocumentAttachmentPolicy) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attachmentPolicies = mapped
    }

    /**
     * @param value The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
     */
    @JvmName("bclphcviexmchsvw")
    public suspend fun coreNetworkConfigurations(`value`: List<GetCoreNetworkPolicyDocumentCoreNetworkConfiguration>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.coreNetworkConfigurations = mapped
    }

    /**
     * @param argument The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
     */
    @JvmName("qgplfmsxwxvqjfss")
    public suspend fun coreNetworkConfigurations(argument: List<suspend GetCoreNetworkPolicyDocumentCoreNetworkConfigurationBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentCoreNetworkConfigurationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.coreNetworkConfigurations = mapped
    }

    /**
     * @param argument The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
     */
    @JvmName("doqdhojoyhgmvugg")
    public suspend fun coreNetworkConfigurations(vararg argument: suspend GetCoreNetworkPolicyDocumentCoreNetworkConfigurationBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentCoreNetworkConfigurationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.coreNetworkConfigurations = mapped
    }

    /**
     * @param argument The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
     */
    @JvmName("hipdpwjsjeljwcrp")
    public suspend fun coreNetworkConfigurations(argument: suspend GetCoreNetworkPolicyDocumentCoreNetworkConfigurationBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetCoreNetworkPolicyDocumentCoreNetworkConfigurationBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.coreNetworkConfigurations = mapped
    }

    /**
     * @param values The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
     */
    @JvmName("hrldqtbnqbbnfdid")
    public suspend fun coreNetworkConfigurations(vararg values: GetCoreNetworkPolicyDocumentCoreNetworkConfiguration) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.coreNetworkConfigurations = mapped
    }

    /**
     * @param value Block argument that defines the service insertion actions you want to include. Detailed below.
     */
    @JvmName("hwglipgirdcvrtng")
    public suspend fun networkFunctionGroups(`value`: List<GetCoreNetworkPolicyDocumentNetworkFunctionGroup>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkFunctionGroups = mapped
    }

    /**
     * @param argument Block argument that defines the service insertion actions you want to include. Detailed below.
     */
    @JvmName("npbuwynbbdnnjlfh")
    public suspend fun networkFunctionGroups(argument: List<suspend GetCoreNetworkPolicyDocumentNetworkFunctionGroupBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentNetworkFunctionGroupBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.networkFunctionGroups = mapped
    }

    /**
     * @param argument Block argument that defines the service insertion actions you want to include. Detailed below.
     */
    @JvmName("ynfmfplgussfclso")
    public suspend fun networkFunctionGroups(vararg argument: suspend GetCoreNetworkPolicyDocumentNetworkFunctionGroupBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentNetworkFunctionGroupBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.networkFunctionGroups = mapped
    }

    /**
     * @param argument Block argument that defines the service insertion actions you want to include. Detailed below.
     */
    @JvmName("cgppmegmierwvwge")
    public suspend fun networkFunctionGroups(argument: suspend GetCoreNetworkPolicyDocumentNetworkFunctionGroupBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetCoreNetworkPolicyDocumentNetworkFunctionGroupBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.networkFunctionGroups = mapped
    }

    /**
     * @param values Block argument that defines the service insertion actions you want to include. Detailed below.
     */
    @JvmName("lxhqsmfdsrndsdku")
    public suspend fun networkFunctionGroups(vararg values: GetCoreNetworkPolicyDocumentNetworkFunctionGroup) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFunctionGroups = mapped
    }

    /**
     * @param value A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("hgskamgleruavsdi")
    public suspend fun segmentActions(`value`: List<GetCoreNetworkPolicyDocumentSegmentAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.segmentActions = mapped
    }

    /**
     * @param argument A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("gluvosfegsfjgjki")
    public suspend fun segmentActions(argument: List<suspend GetCoreNetworkPolicyDocumentSegmentActionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentSegmentActionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.segmentActions = mapped
    }

    /**
     * @param argument A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("sybklikdyfvyvsog")
    public suspend fun segmentActions(vararg argument: suspend GetCoreNetworkPolicyDocumentSegmentActionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentSegmentActionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.segmentActions = mapped
    }

    /**
     * @param argument A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("fjhoobfvuwxmxchp")
    public suspend fun segmentActions(argument: suspend GetCoreNetworkPolicyDocumentSegmentActionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetCoreNetworkPolicyDocumentSegmentActionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.segmentActions = mapped
    }

    /**
     * @param values A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("ybodaqghevksxpvs")
    public suspend fun segmentActions(vararg values: GetCoreNetworkPolicyDocumentSegmentAction) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.segmentActions = mapped
    }

    /**
     * @param value Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("umjnmdcregtaowgq")
    public suspend fun segments(`value`: List<GetCoreNetworkPolicyDocumentSegment>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.segments = mapped
    }

    /**
     * @param argument Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("yimgyiorljdhrcmg")
    public suspend fun segments(argument: List<suspend GetCoreNetworkPolicyDocumentSegmentBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentSegmentBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.segments = mapped
    }

    /**
     * @param argument Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("kmuxbcajkspfsmqs")
    public suspend fun segments(vararg argument: suspend GetCoreNetworkPolicyDocumentSegmentBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentSegmentBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.segments = mapped
    }

    /**
     * @param argument Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("vyvathxbbmnispye")
    public suspend fun segments(argument: suspend GetCoreNetworkPolicyDocumentSegmentBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetCoreNetworkPolicyDocumentSegmentBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.segments = mapped
    }

    /**
     * @param values Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     */
    @JvmName("hjvgedrndcvcowdn")
    public suspend fun segments(vararg values: GetCoreNetworkPolicyDocumentSegment) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.segments = mapped
    }

    /**
     * @param value
     */
    @JvmName("wutdwsadtcgduqod")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentPlainArgs =
        GetCoreNetworkPolicyDocumentPlainArgs(
            attachmentPolicies = attachmentPolicies,
            coreNetworkConfigurations = coreNetworkConfigurations ?: throw
                PulumiNullFieldException("coreNetworkConfigurations"),
            networkFunctionGroups = networkFunctionGroups,
            segmentActions = segmentActions,
            segments = segments ?: throw PulumiNullFieldException("segments"),
            version = version,
        )
}
