@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegment.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowFilters List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
 * @property denyFilters An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
 * @property description A user-defined string describing the segment.
 * @property edgeLocations A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
 * @property isolateAttachments This Boolean setting determines whether attachments on the same segment can communicate with each other. If set to `true`, the only routes available will be either shared routes through the share actions, which are attachments in other segments, or static routes. The default value is `false`. For example, you might have a segment dedicated to "development" that should never allow VPCs to talk to each other, even if they’re on the same segment. In this example, you would keep the default parameter of `false`.
 * @property name Unique name for a segment. The name is a string used in other parts of the policy document, as well as in the console for metrics and other reference points. Valid characters are a–z, and 0–9.
 * @property requireAttachmentAcceptance This Boolean setting determines whether attachment requests are automatically approved or require acceptance. The default is `true`, indicating that attachment requests require acceptance. For example, you might use this setting to allow a "sandbox" segment to allow any attachment request so that a core network or attachment administrator does not need to review and approve attachment requests. In this example, `require_attachment_acceptance` is set to `false`.
 */
public data class GetCoreNetworkPolicyDocumentSegment(
    public val allowFilters: List<String>? = null,
    public val denyFilters: List<String>? = null,
    public val description: String? = null,
    public val edgeLocations: List<String>? = null,
    public val isolateAttachments: Boolean? = null,
    public val name: String,
    public val requireAttachmentAcceptance: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegment> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegment =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegment.builder()
            .allowFilters(allowFilters?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .denyFilters(denyFilters?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.let({ args0 -> args0 }))
            .edgeLocations(edgeLocations?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isolateAttachments(isolateAttachments?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .requireAttachmentAcceptance(requireAttachmentAcceptance?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentSegment].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentSegmentBuilder internal constructor() {
    private var allowFilters: List<String>? = null

    private var denyFilters: List<String>? = null

    private var description: String? = null

    private var edgeLocations: List<String>? = null

    private var isolateAttachments: Boolean? = null

    private var name: String? = null

    private var requireAttachmentAcceptance: Boolean? = null

    /**
     * @param value List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
     */
    @JvmName("qujcwmyxpqmpextn")
    public suspend fun allowFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.allowFilters = mapped
    }

    /**
     * @param values List of strings of segment names that explicitly allows only routes from the segments that are listed in the array. Use the `allow_filter` setting if a segment has a well-defined group of other segments that connectivity should be restricted to. It is applied after routes have been shared in `segment_actions`. If a segment is listed in `allow_filter`, attachments between the two segments will have routes if they are also shared in the segment-actions area. For example, you might have a segment named "video-producer" that should only ever share routes with a "video-distributor" segment, no matter how many other share statements are created.
     */
    @JvmName("bndorlwksmocuojy")
    public suspend fun allowFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.allowFilters = mapped
    }

    /**
     * @param value An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
     */
    @JvmName("omrxyahxnlrtbkmg")
    public suspend fun denyFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.denyFilters = mapped
    }

    /**
     * @param values An array of segments that disallows routes from the segments listed in the array. It is applied only after routes have been shared in `segment_actions`. If a segment is listed in the `deny_filter`, attachments between the two segments will never have routes shared across them. For example, you might have a "financial" payment segment that should never share routes with a "development" segment, regardless of how many other share statements are created. Adding the payments segment to the deny-filter parameter prevents any shared routes from being created with other segments.
     */
    @JvmName("arhthavjdkhdtjwn")
    public suspend fun denyFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.denyFilters = mapped
    }

    /**
     * @param value A user-defined string describing the segment.
     */
    @JvmName("cpjkppdorwhuqkfs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
     */
    @JvmName("afysvcyjanuqlatn")
    public suspend fun edgeLocations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.edgeLocations = mapped
    }

    /**
     * @param values A list of strings of AWS Region names. Allows you to define a more restrictive set of Regions for a segment. The edge location must be a subset of the locations that are defined for `edge_locations` in the `core_network_configuration`.
     */
    @JvmName("yoneywvwipqeqcpx")
    public suspend fun edgeLocations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeLocations = mapped
    }

    /**
     * @param value This Boolean setting determines whether attachments on the same segment can communicate with each other. If set to `true`, the only routes available will be either shared routes through the share actions, which are attachments in other segments, or static routes. The default value is `false`. For example, you might have a segment dedicated to "development" that should never allow VPCs to talk to each other, even if they’re on the same segment. In this example, you would keep the default parameter of `false`.
     */
    @JvmName("rsyxpyaeicvbdsit")
    public suspend fun isolateAttachments(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isolateAttachments = mapped
    }

    /**
     * @param value Unique name for a segment. The name is a string used in other parts of the policy document, as well as in the console for metrics and other reference points. Valid characters are a–z, and 0–9.
     */
    @JvmName("clliyagteekkuiub")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value This Boolean setting determines whether attachment requests are automatically approved or require acceptance. The default is `true`, indicating that attachment requests require acceptance. For example, you might use this setting to allow a "sandbox" segment to allow any attachment request so that a core network or attachment administrator does not need to review and approve attachment requests. In this example, `require_attachment_acceptance` is set to `false`.
     */
    @JvmName("qhjttogtolesnnbv")
    public suspend fun requireAttachmentAcceptance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.requireAttachmentAcceptance = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentSegment = GetCoreNetworkPolicyDocumentSegment(
        allowFilters = allowFilters,
        denyFilters = denyFilters,
        description = description,
        edgeLocations = edgeLocations,
        isolateAttachments = isolateAttachments,
        name = name ?: throw PulumiNullFieldException("name"),
        requireAttachmentAcceptance = requireAttachmentAcceptance,
    )
}
