@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentAction.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take for the chosen segment. Valid values: `create-route`, `share`, `send-via` and `send-to`.
 * @property description A user-defined string describing the segment action.
 * @property destinationCidrBlocks List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
 * @property destinations A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
 * @property mode String. When `action` is `share`, a `mode` value of `attachment-route` places the attachment and return routes in each of the `share_with` segments. When `action` is `send-via`, indicates the mode used for packets. Valid values: `attachment-route`, `single-hop`, `dual-hop`.
 * @property segment Name of the segment.
 * @property shareWithExcepts A set subtraction of segments to not share with.
 * @property shareWiths A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
 * @property via The network function groups and any edge overrides associated with the action.
 * @property whenSentTo The destination segments for the `send-via` or `send-to` `action`.
 */
public data class GetCoreNetworkPolicyDocumentSegmentAction(
    public val action: String,
    public val description: String? = null,
    public val destinationCidrBlocks: List<String>? = null,
    public val destinations: List<String>? = null,
    public val mode: String? = null,
    public val segment: String,
    public val shareWithExcepts: List<String>? = null,
    public val shareWiths: List<String>? = null,
    public val via: GetCoreNetworkPolicyDocumentSegmentActionVia? = null,
    public val whenSentTo: GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentAction> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentAction =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentAction.builder()
            .action(action.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .destinationCidrBlocks(destinationCidrBlocks?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinations(destinations?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .mode(mode?.let({ args0 -> args0 }))
            .segment(segment.let({ args0 -> args0 }))
            .shareWithExcepts(shareWithExcepts?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .shareWiths(shareWiths?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .via(via?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .whenSentTo(whenSentTo?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentSegmentAction].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentSegmentActionBuilder internal constructor() {
    private var action: String? = null

    private var description: String? = null

    private var destinationCidrBlocks: List<String>? = null

    private var destinations: List<String>? = null

    private var mode: String? = null

    private var segment: String? = null

    private var shareWithExcepts: List<String>? = null

    private var shareWiths: List<String>? = null

    private var via: GetCoreNetworkPolicyDocumentSegmentActionVia? = null

    private var whenSentTo: GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo? = null

    /**
     * @param value Action to take for the chosen segment. Valid values: `create-route`, `share`, `send-via` and `send-to`.
     */
    @JvmName("ifsbhltkssmdckpu")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.action = mapped
    }

    /**
     * @param value A user-defined string describing the segment action.
     */
    @JvmName("hiqpkbfsskwmowax")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
     */
    @JvmName("nwapeuqiiptufjsb")
    public suspend fun destinationCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.destinationCidrBlocks = mapped
    }

    /**
     * @param values List of strings containing CIDRs. You can define the IPv4 and IPv6 CIDR notation for each AWS Region. For example, `10.1.0.0/16` or `2001:db8::/56`. This is an array of CIDR notation strings.
     */
    @JvmName("deiexuacybqhombw")
    public suspend fun destinationCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.destinationCidrBlocks = mapped
    }

    /**
     * @param value A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
     */
    @JvmName("dfpjjqekhpqisfdr")
    public suspend fun destinations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.destinations = mapped
    }

    /**
     * @param values A list of strings. Valid values include `["blackhole"]` or a list of attachment ids.
     */
    @JvmName("xfhajlwcoawiwjye")
    public suspend fun destinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.destinations = mapped
    }

    /**
     * @param value String. When `action` is `share`, a `mode` value of `attachment-route` places the attachment and return routes in each of the `share_with` segments. When `action` is `send-via`, indicates the mode used for packets. Valid values: `attachment-route`, `single-hop`, `dual-hop`.
     */
    @JvmName("mxgsxoqrbhdmgair")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mode = mapped
    }

    /**
     * @param value Name of the segment.
     */
    @JvmName("pdivjqafnrikeoef")
    public suspend fun segment(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.segment = mapped
    }

    /**
     * @param value A set subtraction of segments to not share with.
     */
    @JvmName("jrqipcrjddfeuuqp")
    public suspend fun shareWithExcepts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.shareWithExcepts = mapped
    }

    /**
     * @param values A set subtraction of segments to not share with.
     */
    @JvmName("wnxlserjxemjuijm")
    public suspend fun shareWithExcepts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareWithExcepts = mapped
    }

    /**
     * @param value A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
     */
    @JvmName("vhudsvfvtpjmcccm")
    public suspend fun shareWiths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.shareWiths = mapped
    }

    /**
     * @param values A list of strings to share with. Must be a substring is all segments. Valid values include: `["*"]` or `["<segment-names>"]`.
     */
    @JvmName("bnvpvfjcmydlctgk")
    public suspend fun shareWiths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareWiths = mapped
    }

    /**
     * @param value The network function groups and any edge overrides associated with the action.
     */
    @JvmName("exmtqpwxtspvbwwq")
    public suspend fun via(`value`: GetCoreNetworkPolicyDocumentSegmentActionVia?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.via = mapped
    }

    /**
     * @param argument The network function groups and any edge overrides associated with the action.
     */
    @JvmName("kcvmfwqjfsaeuklq")
    public suspend fun via(argument: suspend GetCoreNetworkPolicyDocumentSegmentActionViaBuilder.() -> Unit) {
        val toBeMapped = GetCoreNetworkPolicyDocumentSegmentActionViaBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.via = mapped
    }

    /**
     * @param value The destination segments for the `send-via` or `send-to` `action`.
     */
    @JvmName("maagpnlknehemnsg")
    public suspend fun whenSentTo(`value`: GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.whenSentTo = mapped
    }

    /**
     * @param argument The destination segments for the `send-via` or `send-to` `action`.
     */
    @JvmName("itgnelpvrncoubfp")
    public suspend fun whenSentTo(argument: suspend GetCoreNetworkPolicyDocumentSegmentActionWhenSentToBuilder.() -> Unit) {
        val toBeMapped = GetCoreNetworkPolicyDocumentSegmentActionWhenSentToBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.whenSentTo = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentSegmentAction =
        GetCoreNetworkPolicyDocumentSegmentAction(
            action = action ?: throw PulumiNullFieldException("action"),
            description = description,
            destinationCidrBlocks = destinationCidrBlocks,
            destinations = destinations,
            mode = mode,
            segment = segment ?: throw PulumiNullFieldException("segment"),
            shareWithExcepts = shareWithExcepts,
            shareWiths = shareWiths,
            via = via,
            whenSentTo = whenSentTo,
        )
}
