@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionVia.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property networkFunctionGroups A list of strings. The network function group to use for the service insertion action.
 * @property withEdgeOverrides Any edge overrides and the preferred edge to use.
 */
public data class GetCoreNetworkPolicyDocumentSegmentActionVia(
    public val networkFunctionGroups: List<String>? = null,
    public val withEdgeOverrides: List<GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionVia> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionVia =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionVia.builder()
            .networkFunctionGroups(networkFunctionGroups?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .withEdgeOverrides(
                withEdgeOverrides?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentSegmentActionVia].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentSegmentActionViaBuilder internal constructor() {
    private var networkFunctionGroups: List<String>? = null

    private var withEdgeOverrides: List<GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride>? =
        null

    /**
     * @param value A list of strings. The network function group to use for the service insertion action.
     */
    @JvmName("anglcgxfplbmcykg")
    public suspend fun networkFunctionGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkFunctionGroups = mapped
    }

    /**
     * @param values A list of strings. The network function group to use for the service insertion action.
     */
    @JvmName("mgciionlhxhbqxfg")
    public suspend fun networkFunctionGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkFunctionGroups = mapped
    }

    /**
     * @param value Any edge overrides and the preferred edge to use.
     */
    @JvmName("sgsaonspeucoaqpm")
    public suspend fun withEdgeOverrides(`value`: List<GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.withEdgeOverrides = mapped
    }

    /**
     * @param argument Any edge overrides and the preferred edge to use.
     */
    @JvmName("cykyxtervkujfxal")
    public suspend fun withEdgeOverrides(argument: List<suspend GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.withEdgeOverrides = mapped
    }

    /**
     * @param argument Any edge overrides and the preferred edge to use.
     */
    @JvmName("bsylpevpqlvlhexj")
    public suspend fun withEdgeOverrides(vararg argument: suspend GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.withEdgeOverrides = mapped
    }

    /**
     * @param argument Any edge overrides and the preferred edge to use.
     */
    @JvmName("kfpqfnmummvprugb")
    public suspend fun withEdgeOverrides(argument: suspend GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.withEdgeOverrides = mapped
    }

    /**
     * @param values Any edge overrides and the preferred edge to use.
     */
    @JvmName("ysjsatjkrvcdqaeo")
    public suspend fun withEdgeOverrides(vararg values: GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.withEdgeOverrides = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentSegmentActionVia =
        GetCoreNetworkPolicyDocumentSegmentActionVia(
            networkFunctionGroups = networkFunctionGroups,
            withEdgeOverrides = withEdgeOverrides,
        )
}
