@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property edgeSets A list of strings. The list of edges associated with the network function group.
 * @property useEdge The preferred edge to use.
 */
public data class GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride(
    public val edgeSets: List<String>? = null,
    public val useEdge: String? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride.builder()
            .edgeSets(edgeSets?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .useEdge(useEdge?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverrideBuilder internal constructor() {
    private var edgeSets: List<String>? = null

    private var useEdge: String? = null

    /**
     * @param value A list of strings. The list of edges associated with the network function group.
     */
    @JvmName("oqtsmlsfnwfmeakh")
    public suspend fun edgeSets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.edgeSets = mapped
    }

    /**
     * @param values A list of strings. The list of edges associated with the network function group.
     */
    @JvmName("qptfrilhbiumjkfu")
    public suspend fun edgeSets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeSets = mapped
    }

    /**
     * @param value The preferred edge to use.
     */
    @JvmName("fxyxpcjgcsntfycx")
    public suspend fun useEdge(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.useEdge = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride =
        GetCoreNetworkPolicyDocumentSegmentActionViaWithEdgeOverride(
            edgeSets = edgeSets,
            useEdge = useEdge,
        )
}
