@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property segments A list of strings. The list of segments that the `send-via` `action` uses.
 */
public data class GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo(
    public val segments: List<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo =
        com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo.builder()
            .segments(segments?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo].
 */
@PulumiTagMarker
public class GetCoreNetworkPolicyDocumentSegmentActionWhenSentToBuilder internal constructor() {
    private var segments: List<String>? = null

    /**
     * @param value A list of strings. The list of segments that the `send-via` `action` uses.
     */
    @JvmName("kjvofcecmoryyvph")
    public suspend fun segments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.segments = mapped
    }

    /**
     * @param values A list of strings. The list of segments that the `send-via` `action` uses.
     */
    @JvmName("rtkvoglbdqskdkso")
    public suspend fun segments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.segments = mapped
    }

    internal fun build(): GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo =
        GetCoreNetworkPolicyDocumentSegmentActionWhenSentTo(
            segments = segments,
        )
}
